/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.mysql.diff;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import net.moznion.mysql.diff.MySqlConnectionInfo;

public class SchemaDumper {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final MySqlConnectionInfo localMySqlConnectionInfo;
    private final String mysqldumpPath;

    public SchemaDumper(MySqlConnectionInfo localMySqlConnectionInfo, String mysqldumpPath) {
        if (localMySqlConnectionInfo == null) {
            throw new IllegalArgumentException("mysqlConnectionInfo must not be null");
        }
        if (mysqldumpPath == null) {
            throw new IllegalArgumentException("mysqldumpPath must not be null");
        }
        this.localMySqlConnectionInfo = localMySqlConnectionInfo;
        this.mysqldumpPath = mysqldumpPath;
    }

    public SchemaDumper(MySqlConnectionInfo localMySqlConnectionInfo) {
        this(localMySqlConnectionInfo, "mysqldump");
    }

    public SchemaDumper(String mysqldumpPath) {
        this(MySqlConnectionInfo.builder().build(), mysqldumpPath);
    }

    public SchemaDumper() {
        this(MySqlConnectionInfo.builder().build());
    }

    /*
     * Exception decompiling
     */
    public String dump(String sql) throws SQLException, IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String dump(File sqlFile, Charset charset) throws IOException, SQLException, InterruptedException {
        String sqlString = new String(Files.readAllBytes(Paths.get(sqlFile.getAbsolutePath(), new String[0])), charset);
        return this.dump(sqlString);
    }

    public String dump(File sqlFile) throws IOException, SQLException, InterruptedException {
        return this.dump(sqlFile, StandardCharsets.UTF_8);
    }

    public String dumpFromLocalDb(String dbName) throws IOException, InterruptedException, SQLException {
        return this.fetchSchemaViaMysqldump(dbName);
    }

    public String dumpFromRemoteDb(String dbName, MySqlConnectionInfo mysqlConnectionInfo) throws IOException, InterruptedException, SQLException {
        String schema = this.fetchSchemaViaMysqldump(dbName, mysqlConnectionInfo);
        return this.dump(schema);
    }

    /*
     * WARNING - void declaration
     */
    private String fetchSchemaViaMysqldump(String dbName, MySqlConnectionInfo mysqlConnectionInfo) throws IOException, InterruptedException {
        void var3_20;
        String schema;
        String mysqlHost;
        ArrayList<String> mysqldumpCommand = new ArrayList<String>(Arrays.asList(this.mysqldumpPath, "--no-data=true", dbName));
        String mysqlUser = mysqlConnectionInfo.getUser();
        if (!mysqlUser.isEmpty()) {
            mysqldumpCommand.add("-u" + mysqlUser);
        }
        if (!(mysqlHost = mysqlConnectionInfo.getHost()).isEmpty()) {
            mysqldumpCommand.add("-h" + mysqlHost);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(mysqldumpCommand);
        Process process = processBuilder.start();
        try (InputStream inputStream = process.getInputStream();){
            StringBuilder stdoutStringBuilder = new StringBuilder();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    stdoutStringBuilder.append(line).append(LINE_SEPARATOR);
                }
            }
            schema = stdoutStringBuilder.toString();
        }
        if (process.waitFor() != 0) {
            throw new RuntimeException("Failed to execute `mysqldump` command.\n" + "[command] >>>\n" + String.join((CharSequence)" ", mysqldumpCommand) + "\n<<<\n" + "[output] >>>\n" + schema + "\n<<<\n");
        }
        return var3_20;
    }

    private String fetchSchemaViaMysqldump(String dbName) throws IOException, InterruptedException, SQLException {
        return this.fetchSchemaViaMysqldump(dbName, this.localMySqlConnectionInfo);
    }
}

