/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.mysql.diff.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.moznion.mysql.diff.model.Column;
import net.moznion.mysql.diff.model.OrdinaryKey;
import net.moznion.mysql.diff.model.UniqueKey;

public class Table {
    private final String tableName;
    private final List<String> primaryKeys;
    private final List<UniqueKey> uniqueKeys;
    private final List<OrdinaryKey> keys;
    private final List<Column> columns;
    private final String content;

    public static Builder builder() {
        return new Builder();
    }

    private Table(Builder builder) {
        this.tableName = Optional.ofNullable(builder.tableName).orElseThrow(() -> new IllegalArgumentException("Missing table name"));
        this.primaryKeys = Optional.ofNullable(builder.primaryKeys).orElse(new ArrayList());
        this.uniqueKeys = Optional.ofNullable(builder.uniqueKeys).orElse(new ArrayList());
        this.keys = Optional.ofNullable(builder.keys).orElse(new ArrayList());
        this.columns = Optional.ofNullable(builder.columns).orElse(new ArrayList());
        this.content = Optional.ofNullable(builder.content).orElse("");
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public List<UniqueKey> getUniqueKeys() {
        return this.uniqueKeys;
    }

    public List<OrdinaryKey> getKeys() {
        return this.keys;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public String getContent() {
        return this.content;
    }

    public static class Builder {
        private String tableName;
        private List<String> primaryKeys;
        private List<UniqueKey> uniqueKeys;
        private List<OrdinaryKey> keys;
        private List<Column> columns;
        private String content;

        public Table build() {
            return new Table(this);
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder primaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        public Builder uniqueKeys(List<UniqueKey> uniqueKeys) {
            this.uniqueKeys = uniqueKeys;
            return this;
        }

        public Builder keys(List<OrdinaryKey> keys) {
            this.keys = keys;
            return this;
        }

        public Builder columns(List<Column> columns) {
            this.columns = columns;
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }
    }
}

