/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.protoc.plugin.dynamodb;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.compiler.PluginProtos;
import com.salesforce.jprotoc.Generator;
import com.salesforce.jprotoc.GeneratorException;
import com.salesforce.jprotoc.ProtoTypeMap;
import com.salesforce.jprotoc.ProtocPlugin;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.moznion.protoc.plugin.dynamodb.CodeGenerator;
import net.moznion.protoc.plugin.dynamodb.FileOptions;
import net.moznion.protoc.plugin.dynamodb.OptionsProto;

public class App
extends Generator {
    private ProtoTypeMap protoTypeMap;

    public static void main(String[] args) {
        ProtocPlugin.generate((Generator)new App());
    }

    public List<PluginProtos.CodeGeneratorResponse.File> generateFiles(PluginProtos.CodeGeneratorRequest originalRequest) throws GeneratorException {
        PluginProtos.CodeGeneratorRequest request;
        try {
            ExtensionRegistry registry = ExtensionRegistry.newInstance();
            OptionsProto.registerAllExtensions(registry);
            request = PluginProtos.CodeGeneratorRequest.parseFrom((byte[])originalRequest.toByteArray(), (ExtensionRegistryLite)registry);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        this.protoTypeMap = ProtoTypeMap.of((Collection)request.getProtoFileList());
        return request.getProtoFileList().stream().map(file -> {
            FileOptions opts;
            if (request.getFileToGenerateList().contains((Object)file.getName()) && (opts = FileOptions.from((OptionsProto.FileOptions)file.getOptions().getExtension(OptionsProto.fileopt))).shouldGenerate()) {
                return Optional.of(() -> this.handleProtoFile((DescriptorProtos.FileDescriptorProto)file, opts));
            }
            return Optional.empty();
        }).filter(Optional::isPresent).flatMap(maybeHandler -> (Stream)((Supplier)maybeHandler.get()).get()).collect(Collectors.toList());
    }

    protected List<PluginProtos.CodeGeneratorResponse.Feature> supportedFeatures() {
        return Collections.singletonList(PluginProtos.CodeGeneratorResponse.Feature.FEATURE_NONE);
    }

    private Stream<PluginProtos.CodeGeneratorResponse.File> handleProtoFile(DescriptorProtos.FileDescriptorProto fileDescriptor, FileOptions opts) {
        String protoPackage = fileDescriptor.getPackage();
        String javaPackage = fileDescriptor.getOptions().hasJavaPackage() ? fileDescriptor.getOptions().getJavaPackage() : protoPackage;
        CodeGenerator codeGenerator = new CodeGenerator((arg_0, arg_1) -> ((App)this).applyTemplate(arg_0, arg_1));
        return fileDescriptor.getMessageTypeList().stream().flatMap(descriptor -> codeGenerator.generateDynamodbEntityCode((DescriptorProtos.DescriptorProto)descriptor, this.getFileName(fileDescriptor, (DescriptorProtos.DescriptorProto)descriptor), protoPackage, javaPackage, opts));
    }

    private String getFileName(DescriptorProtos.FileDescriptorProto fileDescriptor, DescriptorProtos.DescriptorProto messageDescriptor) {
        if (fileDescriptor.getOptions().getJavaMultipleFiles()) {
            return messageDescriptor.getName();
        }
        if (fileDescriptor.getOptions().hasJavaOuterClassname()) {
            return fileDescriptor.getOptions().getJavaOuterClassname();
        }
        String protoPackage = fileDescriptor.hasPackage() ? "." + fileDescriptor.getPackage() : "";
        String protoTypeName = protoPackage + "." + messageDescriptor.getName();
        return Optional.ofNullable(this.protoTypeMap.toJavaTypeName(protoTypeName)).map(javaType -> javaType.substring(0, javaType.lastIndexOf(46))).map(javaType -> javaType.substring(javaType.lastIndexOf(46) + 1)).orElseThrow(() -> new IllegalArgumentException("failed to find filename for proto '" + fileDescriptor.getName() + "'"));
    }
}

