/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.protoc.plugin.dynamodb;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.compiler.PluginProtos;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.moznion.protoc.plugin.dynamodb.DynamodbAttributeField;
import net.moznion.protoc.plugin.dynamodb.DynamodbAttributeFields;
import net.moznion.protoc.plugin.dynamodb.DynamodbEntityClassNameProvider;
import net.moznion.protoc.plugin.dynamodb.FileOptions;
import net.moznion.protoc.plugin.dynamodb.OptionsProto;

final class CodeGenerator {
    private static final String NEWLINE = "\n";
    private static final String DIR_SEPARATOR = "/";
    private static final String JAVA_EXTENSION = ".java";
    private static final String CLASS_SCOPE = "class_scope:";
    private static final String TEMPLATES_DIRECTORY = "templates/";
    private static final String BYTES_ARRAY_TYPE = "byte[]";
    private static final Map<Descriptors.FieldDescriptor.JavaType, String> PRIMITIVE_CLASSES_MAP = ImmutableMap.builder().put((Object)Descriptors.FieldDescriptor.JavaType.INT, (Object)Integer.class.getSimpleName()).put((Object)Descriptors.FieldDescriptor.JavaType.LONG, (Object)Long.class.getSimpleName()).put((Object)Descriptors.FieldDescriptor.JavaType.FLOAT, (Object)Float.class.getSimpleName()).put((Object)Descriptors.FieldDescriptor.JavaType.DOUBLE, (Object)Double.class.getSimpleName()).put((Object)Descriptors.FieldDescriptor.JavaType.BOOLEAN, (Object)Boolean.class.getSimpleName()).put((Object)Descriptors.FieldDescriptor.JavaType.STRING, (Object)String.class.getSimpleName()).put((Object)Descriptors.FieldDescriptor.JavaType.BYTE_STRING, (Object)"byte[]").build();
    private final BiFunction<String, Map<String, ?>, String> applyTemplate;

    Stream<PluginProtos.CodeGeneratorResponse.File> generateDynamodbEntityCode(DescriptorProtos.DescriptorProto messageDescriptor, String fileName, String protoPackage, String javaPackage, FileOptions opts) {
        DynamodbAttributeFields fields = new DynamodbAttributeFields(messageDescriptor.getFieldList().stream().filter(field -> !((OptionsProto.FieldOptions)field.getOptions().getExtension(OptionsProto.fieldopt)).getJavaDynamodbIgnore()).map(field -> DynamodbAttributeField.from(field).validate()).collect(Collectors.toList())).validate();
        String dynamodbInnerClassName = new DynamodbEntityClassNameProvider(opts).getDynamodbEntityClassName();
        String javaPackagePath = javaPackage.isEmpty() ? "" : javaPackage.replace(".", DIR_SEPARATOR) + DIR_SEPARATOR;
        Object protoPackagePath = protoPackage.isEmpty() ? "" : protoPackage + ".";
        String outerClassName = messageDescriptor.getName();
        String filePath = javaPackagePath + fileName + JAVA_EXTENSION;
        String fullMethodName = (String)protoPackagePath + outerClassName;
        String dynamoDBEntityCode = this.buildDynamoDBEntityInnerClassCode(opts.getTableName(), outerClassName, dynamodbInnerClassName, fields);
        return Stream.of(PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(filePath).setContent(dynamoDBEntityCode).setInsertionPoint(CLASS_SCOPE + fullMethodName).build());
    }

    private Optional<String> buildAttributesCode(DynamodbAttributeField field) {
        return Optional.of(this.applyTemplate.apply(CodeGenerator.templatePath("attribute.mustache"), (Map<String, ?>)ImmutableMap.builder().put((Object)"javaFieldType", (Object)field.getJavaTypeName()).put((Object)"javaFieldName", (Object)field.getFieldName()).put((Object)"javaMethodName", (Object)this.getJavaMethodName(field.getFieldName())).put((Object)"fieldAliasName", (Object)field.getAliasName()).put((Object)"isHashKey", (Object)field.isHashKey()).put((Object)"isRangeKey", (Object)field.isRangeKey()).put((Object)"gsiHashKeyIndices", (Object)field.getGsiHashKeyIndices().stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", "))).put((Object)"gsiRangeKeyIndices", (Object)field.getGsiRangeKeyIndices().stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", "))).build()));
    }

    private String buildNoArgConstructorCode(String dynamodbInnerClassName) {
        return "  public " + dynamodbInnerClassName + "() {}\n";
    }

    private String buildAllArgsConstructorCode(String dynamodbInnerClassName, DynamodbAttributeFields fields) {
        ArrayList<CallSite> arguments = new ArrayList<CallSite>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (DynamodbAttributeField field : fields.getItems()) {
            String fieldName = field.getFieldName();
            arguments.add((CallSite)((Object)("final " + field.getJavaTypeName() + " " + fieldName)));
            fieldNames.add(fieldName);
        }
        return this.applyTemplate.apply(CodeGenerator.templatePath("dynamodb_entity_all_args_constructor.mustache"), (Map<String, ?>)ImmutableMap.of((Object)"dynamodbInnerClassName", (Object)dynamodbInnerClassName, (Object)"fieldNames", fieldNames, (Object)"arguments", (Object)String.join((CharSequence)", ", arguments)));
    }

    private String buildToOuterClassMethodCode(String outerClassName, DynamodbAttributeFields fields) {
        return this.applyTemplate.apply(CodeGenerator.templatePath("to_outer_class_method.mustache"), (Map<String, ?>)ImmutableMap.of((Object)"outerClassName", (Object)outerClassName, (Object)"decorators", fields.getItems().stream().map(f -> {
            String accessorPrefix = f.isRepeated() ? "addAll" : "set";
            String fieldName = f.getFieldName();
            return ImmutableMap.of((Object)"accessor", (Object)(accessorPrefix + this.getJavaMethodName(fieldName)), (Object)"fieldName", (Object)fieldName, (Object)"isBytes", (Object)f.isBytesArrayType());
        }).collect(Collectors.toList())));
    }

    private String buildToDynamodbEntityCode(String dynamodbInnerClassName, DynamodbAttributeFields fields) {
        return this.applyTemplate.apply(CodeGenerator.templatePath("to_dynamodb_entity_method.mustache"), (Map<String, ?>)ImmutableMap.of((Object)"dynamodbInnerClassName", (Object)dynamodbInnerClassName, (Object)"constructorArgs", (Object)fields.getItems().stream().map(f -> {
            String javaMethodName = this.getJavaMethodName(f.getFieldName()) + (f.isRepeated() ? "List" : "");
            String extensionForBytes = f.getJavaTypeName().equals(BYTES_ARRAY_TYPE) ? ".toByteArray()" : "";
            return "this.get" + javaMethodName + "()" + extensionForBytes;
        }).collect(Collectors.joining(", "))));
    }

    private String buildDynamoDBEntityInnerClassCode(String tableName, String outerClassName, String dynamodbInnerClassName, DynamodbAttributeFields fields) {
        String attributesCode = fields.getItems().stream().map(this::buildAttributesCode).filter(Optional::isPresent).map(Optional::get).collect(Collectors.collectingAndThen(Collectors.joining(NEWLINE), Optional::of)).filter(value -> !value.isEmpty()).orElse("");
        return this.applyTemplate.apply(CodeGenerator.templatePath("dynamodb_entity.mustache"), (Map<String, ?>)ImmutableMap.builder().put((Object)"tableName", (Object)tableName).put((Object)"dynamodbInnerClassName", (Object)dynamodbInnerClassName).put((Object)"attributesCode", (Object)attributesCode).put((Object)"noArgConstructorCode", (Object)this.buildNoArgConstructorCode(dynamodbInnerClassName)).put((Object)"allArgsConstructorCode", (Object)this.buildAllArgsConstructorCode(dynamodbInnerClassName, fields)).put((Object)"toOuterClassCode", (Object)this.buildToOuterClassMethodCode(outerClassName, fields)).put((Object)"toDynamoDBEntityCode", (Object)this.buildToDynamodbEntityCode(dynamodbInnerClassName, fields)).build());
    }

    private static String templatePath(String path) {
        return TEMPLATES_DIRECTORY + path;
    }

    private String getJavaMethodName(String fieldName) {
        return fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1);
    }

    public CodeGenerator(BiFunction<String, Map<String, ?>, String> applyTemplate) {
        this.applyTemplate = applyTemplate;
    }

    public BiFunction<String, Map<String, ?>, String> getApplyTemplate() {
        return this.applyTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeGenerator)) {
            return false;
        }
        CodeGenerator other = (CodeGenerator)o;
        BiFunction<String, Map<String, ?>, String> this$applyTemplate = this.getApplyTemplate();
        BiFunction<String, Map<String, ?>, String> other$applyTemplate = other.getApplyTemplate();
        return !(this$applyTemplate == null ? other$applyTemplate != null : !this$applyTemplate.equals(other$applyTemplate));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BiFunction<String, Map<String, ?>, String> $applyTemplate = this.getApplyTemplate();
        result = result * 59 + ($applyTemplate == null ? 43 : $applyTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "CodeGenerator(applyTemplate=" + this.getApplyTemplate() + ")";
    }
}

