/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.protoc.plugin.dynamodb;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.moznion.protoc.plugin.dynamodb.OptionsProto;

final class DynamodbAttributeField {
    private static final String BYTES_ARRAY_TYPE = "byte[]";
    private static final Map<Descriptors.FieldDescriptor.JavaType, String> PRIMITIVE_CLASSES_MAP = ImmutableMap.builder().put((Object)Descriptors.FieldDescriptor.JavaType.INT, (Object)Integer.class.getSimpleName()).put((Object)Descriptors.FieldDescriptor.JavaType.LONG, (Object)Long.class.getSimpleName()).put((Object)Descriptors.FieldDescriptor.JavaType.FLOAT, (Object)Float.class.getSimpleName()).put((Object)Descriptors.FieldDescriptor.JavaType.DOUBLE, (Object)Double.class.getSimpleName()).put((Object)Descriptors.FieldDescriptor.JavaType.BOOLEAN, (Object)Boolean.class.getSimpleName()).put((Object)Descriptors.FieldDescriptor.JavaType.STRING, (Object)String.class.getSimpleName()).put((Object)Descriptors.FieldDescriptor.JavaType.BYTE_STRING, (Object)"byte[]").build();
    private final String name;
    private final String fieldName;
    private final String aliasName;
    private final boolean isHashKey;
    private final boolean isRangeKey;
    private final Set<String> gsiHashKeyIndices;
    private final Set<String> gsiRangeKeyIndices;
    private final DescriptorProtos.FieldDescriptorProto descriptor;

    static DynamodbAttributeField from(DescriptorProtos.FieldDescriptorProto fieldDescriptor) {
        String fieldName = fieldDescriptor.getName();
        OptionsProto.FieldOptions fieldOpt = (OptionsProto.FieldOptions)fieldDescriptor.getOptions().getExtension(OptionsProto.fieldopt);
        return new DynamodbAttributeField(fieldName, fieldDescriptor.getJsonName(), fieldOpt.getJavaDynamodbAlias(), fieldOpt.getJavaDynamodbHashKey(), fieldOpt.getJavaDynamodbRangeKey(), new HashSet<String>((Collection<String>)fieldOpt.getJavaDynamodbHashKeyGsiNamesList()), new HashSet<String>((Collection<String>)fieldOpt.getJavaDynamodbRangeKeyGsiNamesList()), fieldDescriptor);
    }

    DynamodbAttributeField validate() throws IllegalArgumentException {
        if (this.isHashKey && this.isRangeKey) {
            throw new IllegalArgumentException("hash-key specifier and range-key specifier is exclusive on a field");
        }
        if (this.gsiHashKeyIndices.stream().anyMatch(this.gsiRangeKeyIndices::contains)) {
            throw new IllegalArgumentException("GSI hash-key and GSI range-key specifier is exclusive on a field");
        }
        return this;
    }

    boolean isRepeated() {
        return this.descriptor.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED;
    }

    String getJavaTypeName() {
        DescriptorProtos.FieldDescriptorProto fieldDescriptorProto = this.getDescriptor();
        return Optional.of(fieldDescriptorProto.getType()).map(Descriptors.FieldDescriptor.Type::valueOf).map(Descriptors.FieldDescriptor.Type::getJavaType).map(PRIMITIVE_CLASSES_MAP::get).map(t -> {
            if (this.isRepeated()) {
                if (t.equals(BYTES_ARRAY_TYPE)) {
                    throw new IllegalArgumentException("`repeated bytes` is prohibited type");
                }
                return "java.util.List<" + t + ">";
            }
            return t;
        }).orElseThrow(() -> new IllegalArgumentException("failed to find java type for field:\n" + fieldDescriptorProto));
    }

    boolean isBytesArrayType() {
        return this.getJavaTypeName().equals(BYTES_ARRAY_TYPE);
    }

    public String getName() {
        return this.name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public boolean isHashKey() {
        return this.isHashKey;
    }

    public boolean isRangeKey() {
        return this.isRangeKey;
    }

    public Set<String> getGsiHashKeyIndices() {
        return this.gsiHashKeyIndices;
    }

    public Set<String> getGsiRangeKeyIndices() {
        return this.gsiRangeKeyIndices;
    }

    public DescriptorProtos.FieldDescriptorProto getDescriptor() {
        return this.descriptor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamodbAttributeField)) {
            return false;
        }
        DynamodbAttributeField other = (DynamodbAttributeField)o;
        if (this.isHashKey() != other.isHashKey()) {
            return false;
        }
        if (this.isRangeKey() != other.isRangeKey()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$aliasName = this.getAliasName();
        String other$aliasName = other.getAliasName();
        if (this$aliasName == null ? other$aliasName != null : !this$aliasName.equals(other$aliasName)) {
            return false;
        }
        Set<String> this$gsiHashKeyIndices = this.getGsiHashKeyIndices();
        Set<String> other$gsiHashKeyIndices = other.getGsiHashKeyIndices();
        if (this$gsiHashKeyIndices == null ? other$gsiHashKeyIndices != null : !((Object)this$gsiHashKeyIndices).equals(other$gsiHashKeyIndices)) {
            return false;
        }
        Set<String> this$gsiRangeKeyIndices = this.getGsiRangeKeyIndices();
        Set<String> other$gsiRangeKeyIndices = other.getGsiRangeKeyIndices();
        if (this$gsiRangeKeyIndices == null ? other$gsiRangeKeyIndices != null : !((Object)this$gsiRangeKeyIndices).equals(other$gsiRangeKeyIndices)) {
            return false;
        }
        DescriptorProtos.FieldDescriptorProto this$descriptor = this.getDescriptor();
        DescriptorProtos.FieldDescriptorProto other$descriptor = other.getDescriptor();
        return !(this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHashKey() ? 79 : 97);
        result = result * 59 + (this.isRangeKey() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $aliasName = this.getAliasName();
        result = result * 59 + ($aliasName == null ? 43 : $aliasName.hashCode());
        Set<String> $gsiHashKeyIndices = this.getGsiHashKeyIndices();
        result = result * 59 + ($gsiHashKeyIndices == null ? 43 : ((Object)$gsiHashKeyIndices).hashCode());
        Set<String> $gsiRangeKeyIndices = this.getGsiRangeKeyIndices();
        result = result * 59 + ($gsiRangeKeyIndices == null ? 43 : ((Object)$gsiRangeKeyIndices).hashCode());
        DescriptorProtos.FieldDescriptorProto $descriptor = this.getDescriptor();
        result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
        return result;
    }

    public String toString() {
        return "DynamodbAttributeField(name=" + this.getName() + ", fieldName=" + this.getFieldName() + ", aliasName=" + this.getAliasName() + ", isHashKey=" + this.isHashKey() + ", isRangeKey=" + this.isRangeKey() + ", gsiHashKeyIndices=" + this.getGsiHashKeyIndices() + ", gsiRangeKeyIndices=" + this.getGsiRangeKeyIndices() + ", descriptor=" + this.getDescriptor() + ")";
    }

    private DynamodbAttributeField(String name, String fieldName, String aliasName, boolean isHashKey, boolean isRangeKey, Set<String> gsiHashKeyIndices, Set<String> gsiRangeKeyIndices, DescriptorProtos.FieldDescriptorProto descriptor) {
        this.name = name;
        this.fieldName = fieldName;
        this.aliasName = aliasName;
        this.isHashKey = isHashKey;
        this.isRangeKey = isRangeKey;
        this.gsiHashKeyIndices = gsiHashKeyIndices;
        this.gsiRangeKeyIndices = gsiRangeKeyIndices;
        this.descriptor = descriptor;
    }
}

