/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.protoc.plugin.dynamodb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.moznion.protoc.plugin.dynamodb.DynamodbAttributeField;

final class DynamodbAttributeFields {
    private final List<DynamodbAttributeField> items;

    DynamodbAttributeFields validate() throws IllegalArgumentException {
        boolean hashKeyExists = false;
        boolean rangeKeyExists = false;
        HashMap gsiCounters = new HashMap();
        for (DynamodbAttributeField dynamodbAttributeField : this.items) {
            if (dynamodbAttributeField.isHashKey()) {
                if (hashKeyExists) {
                    throw new IllegalArgumentException("it must have only one hash-key specifier, but that appears multiple times");
                }
                hashKeyExists = true;
            }
            if (dynamodbAttributeField.isRangeKey()) {
                if (rangeKeyExists) {
                    throw new IllegalArgumentException("it must have only one range-key specifier, but that appears multiple times");
                }
                rangeKeyExists = true;
            }
            dynamodbAttributeField.getGsiHashKeyIndices().forEach(idx -> {
                GSICounter gsiCounter = (GSICounter)gsiCounters.get(idx);
                if (gsiCounter == null) {
                    GSICounter counter = new GSICounter();
                    counter.incrementHashKeyCount();
                    gsiCounters.put(idx, counter);
                    return;
                }
                gsiCounter.incrementHashKeyCount();
            });
            dynamodbAttributeField.getGsiRangeKeyIndices().forEach(idx -> {
                GSICounter gsiCounter = (GSICounter)gsiCounters.get(idx);
                if (gsiCounter == null) {
                    GSICounter counter = new GSICounter();
                    counter.incrementRangeKeyCount();
                    gsiCounters.put(idx, counter);
                    return;
                }
                gsiCounter.incrementRangeKeyCount();
            });
        }
        if (!hashKeyExists) {
            throw new IllegalArgumentException("it must have one hash-key specifier, but it doesn't have that");
        }
        for (Map.Entry entry : gsiCounters.entrySet()) {
            ((GSICounter)entry.getValue()).validate((String)entry.getKey());
        }
        return this;
    }

    public DynamodbAttributeFields(List<DynamodbAttributeField> items) {
        this.items = items;
    }

    public List<DynamodbAttributeField> getItems() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamodbAttributeFields)) {
            return false;
        }
        DynamodbAttributeFields other = (DynamodbAttributeFields)o;
        List<DynamodbAttributeField> this$items = this.getItems();
        List<DynamodbAttributeField> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<DynamodbAttributeField> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    public String toString() {
        return "DynamodbAttributeFields(items=" + this.getItems() + ")";
    }

    private static class GSICounter {
        int hashKeyCount = 0;
        int rangeKeyCount = 0;

        void incrementHashKeyCount() {
            ++this.hashKeyCount;
        }

        void incrementRangeKeyCount() {
            ++this.rangeKeyCount;
        }

        void validate(String gsiName) throws IllegalArgumentException {
            if (this.hashKeyCount == 0) {
                throw new IllegalArgumentException("GSI \"" + gsiName + "\" doesn't have the hash key");
            }
            if (this.hashKeyCount >= 2) {
                throw new IllegalArgumentException("GSI \"" + gsiName + "\" has the multiple hash keys, it needs that key has only one GSI hash key");
            }
            if (this.rangeKeyCount >= 2) {
                throw new IllegalArgumentException("GSI \"" + gsiName + "\" has the multiple range keys, it needs that key has only one GSI range key");
            }
        }

        public int getHashKeyCount() {
            return this.hashKeyCount;
        }

        public int getRangeKeyCount() {
            return this.rangeKeyCount;
        }

        public void setHashKeyCount(int hashKeyCount) {
            this.hashKeyCount = hashKeyCount;
        }

        public void setRangeKeyCount(int rangeKeyCount) {
            this.rangeKeyCount = rangeKeyCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GSICounter)) {
                return false;
            }
            GSICounter other = (GSICounter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getHashKeyCount() != other.getHashKeyCount()) {
                return false;
            }
            return this.getRangeKeyCount() == other.getRangeKeyCount();
        }

        protected boolean canEqual(Object other) {
            return other instanceof GSICounter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getHashKeyCount();
            result = result * 59 + this.getRangeKeyCount();
            return result;
        }

        public String toString() {
            return "DynamodbAttributeFields.GSICounter(hashKeyCount=" + this.getHashKeyCount() + ", rangeKeyCount=" + this.getRangeKeyCount() + ")";
        }
    }
}

