/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.redis.script.manager.jedis;

import java.util.Arrays;
import java.util.List;
import net.moznion.redis.script.manager.core.ScriptManager;
import redis.clients.jedis.ScriptingCommands;
import redis.clients.jedis.exceptions.JedisDataException;

public class JedisScriptManager
extends ScriptManager<String, String> {
    private static final String[] EMPTY_VALUE = new String[0];
    private final String script;
    private final ScriptingCommands commands;
    private final boolean useEvalSHA;
    boolean isNoScript;

    public JedisScriptManager(ScriptingCommands commands, String script) {
        this(commands, script, true);
    }

    public JedisScriptManager(ScriptingCommands commands, String script, boolean useEvalSHA) {
        this.commands = commands;
        this.script = script;
        this.useEvalSHA = useEvalSHA;
        this.isNoScript = true;
    }

    public Object eval(String[] keys) {
        return this.eval(keys, EMPTY_VALUE);
    }

    public Object eval(String[] keys, String[] values) {
        List<String> valuesList;
        List<String> keysList;
        block3: {
            keysList = Arrays.asList(keys);
            valuesList = Arrays.asList(values);
            this.isNoScript = false;
            if (this.useEvalSHA) {
                String sha1 = this.getSHA1(this.script);
                try {
                    return this.commands.evalsha(sha1, keysList, valuesList);
                }
                catch (JedisDataException e) {
                    if (e.getMessage().startsWith("NOSCRIPT")) break block3;
                    throw e;
                }
            }
        }
        this.isNoScript = true;
        return this.commands.eval(this.script, keysList, valuesList);
    }
}

