/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.docs;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Objects;
import net.nemerosa.ontrack.docs.DSLDoc;
import net.nemerosa.ontrack.docs.DSLDocClass;
import net.nemerosa.ontrack.docs.DSLDocMethod;
import net.nemerosa.ontrack.docs.GroovyDocHelper;
import net.nemerosa.ontrack.dsl.doc.DSL;
import net.nemerosa.ontrack.dsl.doc.DSLMethod;
import net.nemerosa.ontrack.dsl.doc.DSLProperties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.groovydoc.GroovyMethodDoc;
import org.codehaus.groovy.groovydoc.GroovyParameter;

public class DSLDocExtractor {
    private final GroovyDocHelper groovyDocHelper;

    public DSLDocExtractor(String sourcePath) {
        this.groovyDocHelper = new GroovyDocHelper(sourcePath);
    }

    public DSLDoc generate(Class<?> clazz) throws IOException {
        DSLDoc doc = new DSLDoc();
        this.generateDocClass(doc, clazz);
        return doc;
    }

    private DSLDocClass generateDocClass(DSLDoc doc, Class<?> clazz) throws IOException {
        DSL dsl = clazz.getAnnotation(DSL.class);
        if (dsl != null) {
            DSLDocClass dslDocClass = (DSLDocClass)doc.getClasses().get(clazz.getName());
            if (dslDocClass == null) {
                Method[] methods;
                System.out.format("[doc] %s%n", clazz.getName());
                dslDocClass = new DSLDocClass(clazz.getSimpleName(), this.getClassDescription(dsl), this.getClassLongDescription(clazz), this.getClassSample(clazz), clazz.getAnnotation(DSLProperties.class) != null);
                doc.getClasses().put(clazz.getName(), dslDocClass);
                for (Method method : methods = clazz.getDeclaredMethods()) {
                    this.generateDocMethod(doc, dslDocClass, clazz, method);
                }
                Class<?> superclass = clazz.getSuperclass();
                DSLDocClass dslSuperClass = this.generateDocClass(doc, superclass);
                if (dslSuperClass != null) {
                    dslDocClass.getReferences().add(dslSuperClass);
                }
                return dslDocClass;
            }
            return dslDocClass;
        }
        return null;
    }

    private void generateDocMethod(DSLDoc doc, DSLDocClass docClass, Class<?> clazz, Method method) throws IOException {
        DSLMethod methodDsl = method.getAnnotation(DSLMethod.class);
        if (methodDsl != null) {
            boolean consistent;
            boolean bl = consistent = methodDsl.count() < 0 || methodDsl.count() == method.getParameterTypes().length;
            if (consistent) {
                GroovyMethodDoc groovyMethodDoc = this.groovyDocHelper.getAllMethods(clazz).stream().filter(gm -> StringUtils.equals((CharSequence)gm.name(), (CharSequence)method.getName())).filter(gm -> Objects.equals(GroovyDocHelper.getMethodFromGroovyMethodDoc((GroovyMethodDoc)gm, (Class)clazz), method)).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find doc for method: " + method));
                DSLDocMethod docMethod = new DSLDocMethod(this.getMethodId(methodDsl, method), this.getMethodName(method), this.getMethodSignature(groovyMethodDoc, method), this.getMethodDescription(methodDsl), this.getMethodLongDescription(methodDsl, clazz, method), this.getMethodSample(methodDsl, clazz, method), methodDsl.see());
                docClass.getMethods().add(docMethod);
                DSLDocClass dslDocClass = null;
                Type genericReturnType = method.getGenericReturnType();
                if (genericReturnType instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
                    for (Type type : parameterizedType.getActualTypeArguments()) {
                        if (!(type instanceof Class)) continue;
                        dslDocClass = this.generateDocClass(doc, (Class)type);
                    }
                } else {
                    dslDocClass = this.generateDocClass(doc, method.getReturnType());
                }
                if (dslDocClass != null && !StringUtils.equals((CharSequence)docClass.getId(), (CharSequence)dslDocClass.getId())) {
                    if (dslDocClass.isPropertyClass()) {
                        docClass.getProperties().set(dslDocClass);
                    } else {
                        docMethod.getReferences().add(dslDocClass);
                    }
                }
            }
        }
    }

    private String getMethodId(DSLMethod methodDsl, Method method) {
        if (StringUtils.isNotBlank((CharSequence)methodDsl.id())) {
            return methodDsl.id();
        }
        return method.getName();
    }

    private String getMethodSignature(GroovyMethodDoc groovyMethodDoc, Method method) {
        StringBuilder s = new StringBuilder();
        Type genericReturnType = method.getGenericReturnType();
        if (genericReturnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
            s.append(method.getReturnType().getSimpleName());
            s.append("<");
            for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                Type type = parameterizedType.getActualTypeArguments()[i];
                if (!(type instanceof Class)) continue;
                if (i > 0) {
                    s.append(",");
                }
                s.append(((Class)type).getSimpleName());
            }
            s.append(">");
        } else {
            s.append(method.getReturnType().getSimpleName());
        }
        s.append(" ").append(method.getName());
        s.append("(");
        GroovyParameter[] parameters = groovyMethodDoc.parameters();
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            GroovyParameter gp = parameters[i];
            String name = gp.name();
            if (i > 0) {
                s.append(", ");
            }
            s.append(parameterType.getSimpleName()).append(" ").append(name);
            String defaultValue = gp.defaultValue();
            if (defaultValue == null) continue;
            s.append(" = ").append(defaultValue);
        }
        s.append(")");
        return s.toString();
    }

    private String getMethodSample(DSLMethod methodDsl, Class<?> clazz, Method method) throws IOException {
        String path = String.format("/%s/%s.groovy", method.getDeclaringClass().getName(), this.getMethodId(methodDsl, method));
        InputStream in = clazz.getResourceAsStream(path);
        if (in != null) {
            return IOUtils.toString((InputStream)in, (Charset)Charset.forName("UTF-8"));
        }
        return null;
    }

    private String getClassSample(Class<?> clazz) throws IOException {
        String path = String.format("/%s/sample.groovy", clazz.getName());
        InputStream in = clazz.getResourceAsStream(path);
        if (in != null) {
            return IOUtils.toString((InputStream)in, (Charset)Charset.forName("UTF-8"));
        }
        return null;
    }

    private String getMethodDescription(DSLMethod methodDsl) {
        if (StringUtils.isNotBlank((CharSequence)methodDsl.value())) {
            return methodDsl.value();
        }
        return null;
    }

    private String getMethodLongDescription(DSLMethod methodDsl, Class<?> clazz, Method method) throws IOException {
        InputStream in = clazz.getResourceAsStream(String.format("/%s/%s.adoc", method.getDeclaringClass().getName(), this.getMethodId(methodDsl, method)));
        if (in != null) {
            return IOUtils.toString((InputStream)in, (Charset)Charset.forName("UTF-8"));
        }
        return null;
    }

    private String getClassLongDescription(Class<?> clazz) throws IOException {
        InputStream in = clazz.getResourceAsStream(String.format("/%s/description.adoc", clazz.getName()));
        if (in != null) {
            return IOUtils.toString((InputStream)in, (Charset)Charset.forName("UTF-8"));
        }
        return null;
    }

    private String getMethodName(Method method) {
        return method.getName();
    }

    private String getClassDescription(DSL dsl) {
        if (StringUtils.isNotBlank((CharSequence)dsl.value())) {
            return dsl.value();
        }
        return null;
    }
}

