/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.ui.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.ui.controller.MockURIBuilder;
import net.nemerosa.ontrack.ui.controller.URIBuilder;
import net.nemerosa.ontrack.ui.resource.DefaultResourceContext;
import net.nemerosa.ontrack.ui.resource.ResourceContext;
import net.nemerosa.ontrack.ui.resource.ResourceObjectMapper;
import net.nemerosa.ontrack.ui.resource.ResourceObjectMapperFactory;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.Mockito;

public abstract class AbstractResourceTest {
    protected ResourceObjectMapper mapper;
    protected SecurityService securityService;

    @Before
    public void before() {
        this.securityService = (SecurityService)Mockito.mock(SecurityService.class);
        this.mapper = new ResourceObjectMapperFactory().resourceObjectMapper(Collections.emptyList(), (ResourceContext)new DefaultResourceContext((URIBuilder)new MockURIBuilder(), this.securityService));
    }

    public static void assertResourceJson(ResourceObjectMapper mapper, JsonNode expectedJson, Object o) throws JsonProcessingException {
        Assert.assertEquals((Object)mapper.getObjectMapper().writeValueAsString((Object)expectedJson), (Object)mapper.write(o));
    }

    public static void assertResourceJson(ResourceObjectMapper mapper, JsonNode expectedJson, Object o, Class<?> view) throws JsonProcessingException {
        Assert.assertEquals((Object)mapper.getObjectMapper().writeValueAsString((Object)expectedJson), (Object)mapper.write(o, view));
    }
}

