/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.ui.resource;

import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.ranges.IntRange;
import kotlin.test.AssertionsKt;
import net.nemerosa.ontrack.model.support.Page;
import net.nemerosa.ontrack.ui.resource.PaginatedList;
import net.nemerosa.ontrack.ui.resource.Pagination;
import net.nemerosa.ontrack.ui.resource.PaginationTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0007J\b\u0010\f\u001a\u00020\nH\u0007J\b\u0010\r\u001a\u00020\nH\u0007J\b\u0010\u000e\u001a\u00020\nH\u0007J\b\u0010\u000f\u001a\u00020\nH\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/nemerosa/ontrack/ui/resource/PaginationTest;", "", "()V", "list", "", "", "uriSupplier", "Lkotlin/Function2;", "Ljava/net/URI;", "First page", "", "Last page", "Page size too big with offset 0", "Page size too big with offset gt 0", "Second page", "Third page", "ontrack-ui-support"})
public final class PaginationTest {
    @NotNull
    private final List<Integer> list = CollectionsKt.toList((Iterable)((Iterable)new IntRange(1, 32)));
    @NotNull
    private final Function2<Integer, Integer, URI> uriSupplier = uriSupplier.1.INSTANCE;

    @Test
    public final void First page() {
        PaginatedList paginatedList = Pagination.Companion.paginate(this.list, new Page(0, 10), this.uriSupplier);
        List items = paginatedList.component1();
        Pagination pagination = paginatedList.component2();
        AssertionsKt.assertEquals$default((Object)CollectionsKt.toList((Iterable)((Iterable)new IntRange(1, 10))), (Object)items, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)0, (Object)pagination.getOffset(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)10, (Object)pagination.getLimit(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)32, (Object)pagination.getTotal(), null, (int)4, null);
        AssertionsKt.assertNull$default((Object)pagination.getPrev(), null, (int)2, null);
        AssertionsKt.assertEquals$default((Object)new URI("uri:page:10:10"), (Object)pagination.getNext(), null, (int)4, null);
    }

    @Test
    public final void Second page() {
        PaginatedList paginatedList = Pagination.Companion.paginate(this.list, new Page(10, 10), this.uriSupplier);
        List items = paginatedList.component1();
        Pagination pagination = paginatedList.component2();
        AssertionsKt.assertEquals$default((Object)CollectionsKt.toList((Iterable)((Iterable)new IntRange(11, 20))), (Object)items, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)10, (Object)pagination.getOffset(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)10, (Object)pagination.getLimit(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)32, (Object)pagination.getTotal(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)new URI("uri:page:0:10"), (Object)pagination.getPrev(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)new URI("uri:page:20:10"), (Object)pagination.getNext(), null, (int)4, null);
    }

    @Test
    public final void Third page() {
        PaginatedList paginatedList = Pagination.Companion.paginate(this.list, new Page(20, 10), this.uriSupplier);
        List items = paginatedList.component1();
        Pagination pagination = paginatedList.component2();
        AssertionsKt.assertEquals$default((Object)CollectionsKt.toList((Iterable)((Iterable)new IntRange(21, 30))), (Object)items, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)20, (Object)pagination.getOffset(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)10, (Object)pagination.getLimit(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)32, (Object)pagination.getTotal(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)new URI("uri:page:10:10"), (Object)pagination.getPrev(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)new URI("uri:page:30:10"), (Object)pagination.getNext(), null, (int)4, null);
    }

    @Test
    public final void Last page() {
        PaginatedList paginatedList = Pagination.Companion.paginate(this.list, new Page(30, 10), this.uriSupplier);
        List items = paginatedList.component1();
        Pagination pagination = paginatedList.component2();
        AssertionsKt.assertEquals$default((Object)CollectionsKt.toList((Iterable)((Iterable)new IntRange(31, 32))), (Object)items, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)30, (Object)pagination.getOffset(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)2, (Object)pagination.getLimit(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)32, (Object)pagination.getTotal(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)new URI("uri:page:20:10"), (Object)pagination.getPrev(), null, (int)4, null);
        AssertionsKt.assertNull$default((Object)pagination.getNext(), null, (int)2, null);
    }

    @Test
    public final void Page size too big with offset 0() {
        PaginatedList paginatedList = Pagination.Companion.paginate(this.list, new Page(0, 40), this.uriSupplier);
        List items = paginatedList.component1();
        Pagination pagination = paginatedList.component2();
        AssertionsKt.assertEquals$default((Object)CollectionsKt.toList((Iterable)((Iterable)new IntRange(1, 32))), (Object)items, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)0, (Object)pagination.getOffset(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)32, (Object)pagination.getLimit(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)32, (Object)pagination.getTotal(), null, (int)4, null);
        AssertionsKt.assertNull$default((Object)pagination.getPrev(), null, (int)2, null);
        AssertionsKt.assertNull$default((Object)pagination.getNext(), null, (int)2, null);
    }

    @Test
    public final void Page size too big with offset gt 0() {
        PaginatedList paginatedList = Pagination.Companion.paginate(this.list, new Page(10, 40), this.uriSupplier);
        List items = paginatedList.component1();
        Pagination pagination = paginatedList.component2();
        AssertionsKt.assertEquals$default((Object)CollectionsKt.toList((Iterable)((Iterable)new IntRange(11, 32))), (Object)items, null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)10, (Object)pagination.getOffset(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)22, (Object)pagination.getLimit(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)32, (Object)pagination.getTotal(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)new URI("uri:page:0:40"), (Object)pagination.getPrev(), null, (int)4, null);
        AssertionsKt.assertNull$default((Object)pagination.getNext(), null, (int)2, null);
    }
}

