/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.ui.resource;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.support.ApplicationLogEntry;
import net.nemerosa.ontrack.model.support.ApplicationLogService;
import net.nemerosa.ontrack.ui.resource.LinkDefinition;
import net.nemerosa.ontrack.ui.resource.LinkDefinitions;
import net.nemerosa.ontrack.ui.resource.ResourceDecorationContributor;
import net.nemerosa.ontrack.ui.resource.ResourceDecorationContributorService;
import net.nemerosa.ontrack.ui.resource.ResourceDecorationContributorServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ResourceDecorationContributorServiceTest {
    private ApplicationLogService logService;

    @Before
    public void before() {
        this.logService = (ApplicationLogService)Mockito.mock(ApplicationLogService.class);
    }

    @Test
    public void no_contribution() {
        ResourceDecorationContributor contributor = (ResourceDecorationContributor)Mockito.mock(ResourceDecorationContributor.class);
        Mockito.when((Object)contributor.applyTo((ProjectEntityType)Mockito.any(ProjectEntityType.class))).thenReturn((Object)false);
        ResourceDecorationContributorServiceImpl service = new ResourceDecorationContributorServiceImpl(this.logService, Collections.singletonList(contributor));
        Stream.of(ProjectEntityType.values()).forEach(arg_0 -> ResourceDecorationContributorServiceTest.lambda$no_contribution$0((ResourceDecorationContributorService)service, arg_0));
    }

    @Test
    public void one_type_contribution() {
        ResourceDecorationContributor contributor = new ResourceDecorationContributor(){

            public List<LinkDefinition> getLinkDefinitions() {
                return Collections.singletonList(LinkDefinitions.page());
            }

            public boolean applyTo(ProjectEntityType projectEntityType) {
                return projectEntityType == ProjectEntityType.BRANCH;
            }
        };
        ResourceDecorationContributorServiceImpl service = new ResourceDecorationContributorServiceImpl(this.logService, Collections.singletonList(contributor));
        Stream.of(ProjectEntityType.values()).forEach(arg_0 -> ResourceDecorationContributorServiceTest.lambda$one_type_contribution$1((ResourceDecorationContributorService)service, arg_0));
    }

    @Test
    public void contributions() {
        ResourceDecorationContributor contributor1 = new ResourceDecorationContributor(){

            public List<LinkDefinition> getLinkDefinitions() {
                return Collections.singletonList(LinkDefinitions.page((String)"_page1", (b, rc) -> true, (String)"page1", (Object[])new Object[0]));
            }

            public boolean applyTo(ProjectEntityType projectEntityType) {
                return projectEntityType == ProjectEntityType.BRANCH;
            }
        };
        ResourceDecorationContributor contributor2 = new ResourceDecorationContributor(){

            public List<LinkDefinition> getLinkDefinitions() {
                return Collections.singletonList(LinkDefinitions.page((String)"_page2", (b, rc) -> true, (String)"page2", (Object[])new Object[0]));
            }

            public boolean applyTo(ProjectEntityType projectEntityType) {
                return projectEntityType == ProjectEntityType.BRANCH;
            }
        };
        ResourceDecorationContributorServiceImpl service = new ResourceDecorationContributorServiceImpl(this.logService, Arrays.asList(contributor1, contributor2));
        List linkDefinitions = service.getLinkDefinitions(ProjectEntityType.BRANCH);
        Assert.assertEquals((long)2L, (long)linkDefinitions.size());
        Assert.assertEquals((Object)"_page1", (Object)((LinkDefinition)linkDefinitions.get(0)).getName());
        Assert.assertEquals((Object)"_page2", (Object)((LinkDefinition)linkDefinitions.get(1)).getName());
    }

    @Test
    public void contribution_one_error() {
        ResourceDecorationContributor contributor1 = new ResourceDecorationContributor(){

            public List<LinkDefinition> getLinkDefinitions() {
                return Collections.singletonList(LinkDefinitions.page((String)"_page1", (b, rc) -> true, (String)"page1", (Object[])new Object[0]));
            }

            public boolean applyTo(ProjectEntityType projectEntityType) {
                return projectEntityType == ProjectEntityType.BRANCH;
            }
        };
        ResourceDecorationContributor contributor2 = new ResourceDecorationContributor(){

            public List<LinkDefinition> getLinkDefinitions() {
                throw new RuntimeException("Ooops");
            }

            public boolean applyTo(ProjectEntityType projectEntityType) {
                return projectEntityType == ProjectEntityType.BRANCH;
            }
        };
        ResourceDecorationContributorServiceImpl service = new ResourceDecorationContributorServiceImpl(this.logService, Arrays.asList(contributor1, contributor2));
        List linkDefinitions = service.getLinkDefinitions(ProjectEntityType.BRANCH);
        Assert.assertEquals((long)1L, (long)linkDefinitions.size());
        Assert.assertEquals((Object)"_page1", (Object)((LinkDefinition)linkDefinitions.get(0)).getName());
        ((ApplicationLogService)Mockito.verify((Object)this.logService, (VerificationMode)Mockito.times((int)1))).log((ApplicationLogEntry)Mockito.any(ApplicationLogEntry.class));
    }

    private static /* synthetic */ void lambda$one_type_contribution$1(ResourceDecorationContributorService service, ProjectEntityType type) {
        List linkDefinitions = service.getLinkDefinitions(type);
        if (type == ProjectEntityType.BRANCH) {
            Assert.assertEquals((long)1L, (long)linkDefinitions.size());
            LinkDefinition link = (LinkDefinition)linkDefinitions.get(0);
            Assert.assertEquals((Object)"_page", (Object)link.getName());
        } else {
            Assert.assertTrue((boolean)linkDefinitions.isEmpty());
        }
    }

    private static /* synthetic */ void lambda$no_contribution$0(ResourceDecorationContributorService service, ProjectEntityType type) {
        List linkDefinitions = service.getLinkDefinitions(type);
        Assert.assertTrue((boolean)linkDefinitions.isEmpty());
    }
}

