/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.ui.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.json.ObjectMapperFactory;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.TestFixtures;
import net.nemerosa.ontrack.ui.resource.AbstractResourceTest;
import net.nemerosa.ontrack.ui.resource.Dummy;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.junit.Test;

public class ResourcesTest
extends AbstractResourceTest {
    @Test
    public void to_json() throws JsonProcessingException {
        Resources collection = Resources.of(Arrays.asList(new Dummy("1"), new Dummy("2")), (URI)URI.create("http://host/dummy"));
        ResourcesTest.assertResourceJson(this.mapper, (JsonNode)JsonUtils.object().with("_self", "http://host/dummy").with("resources", (JsonNode)JsonUtils.array().with((JsonNode)JsonUtils.object().with("version", "1").end()).with((JsonNode)JsonUtils.object().with("version", "2").end()).end()).end(), ObjectMapperFactory.create().valueToTree((Object)collection));
    }

    @Test
    public void resource_collection_with_filtering() throws JsonProcessingException {
        Project project = Project.of((NameDescription)new NameDescription("PRJ", "Project"));
        List<Branch> branches = Arrays.asList(Branch.of((Project)project, (NameDescription)new NameDescription("B1", "Branch 1")).withSignature(TestFixtures.SIGNATURE), Branch.of((Project)project, (NameDescription)new NameDescription("B2", "Branch 2")).withSignature(TestFixtures.SIGNATURE));
        Resources resourceCollection = Resources.of(branches, (URI)URI.create("urn:branch"));
        ResourcesTest.assertResourceJson(this.mapper, (JsonNode)JsonUtils.object().with("_self", "urn:branch").with("resources", (JsonNode)JsonUtils.array().with((JsonNode)JsonUtils.object().with("id", 0).with("name", "B1").with("description", "Branch 1").with("disabled", false).with("signature", (JsonNode)TestFixtures.SIGNATURE_OBJECT).end()).with((JsonNode)JsonUtils.object().with("id", 0).with("name", "B2").with("description", "Branch 2").with("disabled", false).with("signature", (JsonNode)TestFixtures.SIGNATURE_OBJECT).end()).end()).end(), resourceCollection, Resources.class);
    }
}

