/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.bytesio;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class LimitedInputStream
extends FilterInputStream {
    private long remaining;

    LimitedInputStream(InputStream stream, long limit) {
        super(stream);
        this.remaining = limit;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        int byteRead = super.read();
        if (byteRead != -1) {
            --this.remaining;
        }
        return byteRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nbBytesToRead = Math.min(len, (int)this.remaining);
        int nbBytesRead = super.read(b, off, nbBytesToRead);
        this.remaining -= (long)nbBytesRead;
        return nbBytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

