/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.bytesio;

import java.io.IOException;
import net.netheos.pcsapi.bytesio.ByteSinkStream;
import net.netheos.pcsapi.bytesio.ProgressListener;

public class ProgressByteSinkStream
extends ByteSinkStream {
    private final ProgressListener listener;
    private final ByteSinkStream byteSinkStream;
    private long currentBytes;

    public ProgressByteSinkStream(ByteSinkStream byteSinkStream, ProgressListener listener) {
        super(byteSinkStream);
        this.listener = listener;
        this.byteSinkStream = byteSinkStream;
    }

    public long getCurrentBytes() {
        return this.currentBytes;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.addBytes(1L);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.addBytes(len);
    }

    private void addBytes(long n) {
        if (n >= 0L) {
            this.currentBytes += n;
            this.listener.progress(this.currentBytes);
        }
    }

    @Override
    public void abort() {
        this.listener.aborted();
        this.byteSinkStream.abort();
    }

    @Override
    public boolean isAborted() {
        return this.byteSinkStream.isAborted();
    }
}

