/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.bytesio;

import java.io.IOException;
import java.io.InputStream;
import net.netheos.pcsapi.bytesio.ByteSource;
import net.netheos.pcsapi.bytesio.ProgressInputStream;
import net.netheos.pcsapi.bytesio.ProgressListener;

public class ProgressByteSource
implements ByteSource {
    private ByteSource source;
    private ProgressListener listener;

    public ProgressByteSource(ByteSource source, ProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("ProgressListener cannot be null");
        }
        this.source = source;
        this.listener = listener;
    }

    @Override
    public InputStream openStream() throws IOException {
        InputStream is = this.source.openStream();
        ProgressInputStream pis = new ProgressInputStream(is, this.listener);
        this.listener.setProgressTotal(this.length());
        this.listener.progress(0L);
        return pis;
    }

    @Override
    public long length() {
        return this.source.length();
    }
}

