/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.credentials;

import java.util.Date;
import net.netheos.pcsapi.credentials.OAuth2Credentials;
import net.netheos.pcsapi.credentials.PasswordCredentials;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class Credentials {
    abstract String toJson();

    public static Credentials createFromJson(String json) {
        JSONObject jsonObj = (JSONObject)new JSONTokener(json).nextValue();
        if (jsonObj.has("password")) {
            String password = jsonObj.optString("password", null);
            return new PasswordCredentials(password);
        }
        String accessToken = jsonObj.optString("access_token", null);
        long expiresAt_s = jsonObj.optLong("expires_at", -1L);
        String refreshToken = jsonObj.optString("refresh_token", null);
        String tokenType = jsonObj.optString("token_type", null);
        Date expireAt = null;
        if (expiresAt_s != -1L) {
            expireAt = new Date(expiresAt_s * 1000L);
        }
        return new OAuth2Credentials(accessToken, expireAt, refreshToken, tokenType);
    }
}

