/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.credentials;

import java.util.Date;
import net.netheos.pcsapi.credentials.Credentials;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Credentials
extends Credentials {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2Credentials.class);
    static final String ACCESS_TOKEN = "access_token";
    static final String EXPIRES_IN = "expires_in";
    static final String EXPIRES_AT = "expires_at";
    static final String TOKEN_TYPE = "token_type";
    private String accessToken;
    private Date expiresAt;
    private String refreshToken;
    private String tokenType;

    OAuth2Credentials(String accessToken, Date expiresAt, String refreshToken, String tokenType) {
        this.accessToken = accessToken;
        this.expiresAt = expiresAt;
        this.refreshToken = refreshToken;
        this.tokenType = tokenType;
    }

    public boolean hasExpired() {
        if (this.expiresAt == null) {
            LOGGER.debug("hasExpired - token is not expirable");
            return false;
        }
        long now = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("hasExpired? - now: {} expiredAt: {} ", (Object)new Date(now), (Object)this.expiresAt);
        }
        return now > this.expiresAt.getTime();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void update(JSONObject json) {
        this.accessToken = json.getString(ACCESS_TOKEN);
        this.tokenType = json.getString(TOKEN_TYPE);
        this.expiresAt = new Date(System.currentTimeMillis() + (long)(json.getInt(EXPIRES_IN) * 1000));
        if (json.has("refresh_token")) {
            this.refreshToken = json.getString("refresh_token");
        }
    }

    @Override
    public String toJson() {
        JSONObject jObj = new JSONObject();
        jObj.put(ACCESS_TOKEN, (Object)this.accessToken);
        if (this.expiresAt != null) {
            jObj.put(EXPIRES_AT, this.expiresAt.getTime() / 1000L);
        }
        if (this.refreshToken != null) {
            jObj.put("refresh_token", (Object)this.refreshToken);
        }
        if (this.tokenType != null) {
            jObj.put(TOKEN_TYPE, (Object)this.tokenType);
        }
        return jObj.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof OAuth2Credentials) {
            OAuth2Credentials creds = (OAuth2Credentials)obj;
            return this.accessToken.equals(creds.accessToken);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + (this.accessToken != null ? this.accessToken.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "OAuth2Credentials {expiresAt=" + this.expiresAt + ", tokenType='" + this.tokenType + "'}";
    }
}

