/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.credentials;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.netheos.pcsapi.credentials.AppInfo;
import net.netheos.pcsapi.credentials.Credentials;
import net.netheos.pcsapi.credentials.UserCredentials;
import net.netheos.pcsapi.credentials.UserCredentialsRepository;
import net.netheos.pcsapi.utils.PcsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCredentialsFileRepository
implements UserCredentialsRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserCredentialsFileRepository.class);
    private final File file;
    private final Map<String, Credentials> credentialsMap;

    public UserCredentialsFileRepository(File file) throws IOException {
        this.file = file;
        this.credentialsMap = new HashMap<String, Credentials>();
        if (file.exists()) {
            this.readFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile() throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), PcsUtils.UTF8));
            LOGGER.debug("Reading credentials file {}", (Object)this.file);
            int index = 1;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                String[] userCredentialsArray = line.split("=", 2);
                if (userCredentialsArray.length != 2) {
                    throw new IllegalArgumentException("Not parsable line #" + index);
                }
                String key = userCredentialsArray[0].trim();
                Credentials value = Credentials.createFromJson(userCredentialsArray[1].trim());
                this.credentialsMap.put(key, value);
                ++index;
            }
        }
        catch (Throwable throwable) {
            PcsUtils.closeQuietly(reader);
            throw throwable;
        }
        PcsUtils.closeQuietly(reader);
    }

    @Override
    public synchronized void save(UserCredentials<?> userCredentials) throws IOException {
        String key = this.getUserKey(userCredentials.getAppInfo(), userCredentials.getUserId());
        this.credentialsMap.put(key, (Credentials)userCredentials.getCredentials());
        this.writeFile();
    }

    @Override
    public synchronized UserCredentials<?> get(AppInfo appInfo, String userId) {
        Credentials credentials = null;
        if (userId != null) {
            String key = this.getUserKey(appInfo, userId);
            credentials = this.credentialsMap.get(key);
        } else {
            String prefix = this.getAppPrefix(appInfo);
            for (String key : this.credentialsMap.keySet()) {
                if (!key.startsWith(prefix)) continue;
                userId = key.substring(prefix.length());
                if (credentials != null) {
                    throw new IllegalStateException("Several user credentials found for application " + appInfo);
                }
                credentials = this.credentialsMap.get(key);
            }
        }
        if (credentials == null) {
            throw new IllegalStateException("No user credentials found for application " + appInfo);
        }
        return new UserCredentials<Credentials>(appInfo, userId, credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile() throws IOException {
        LOGGER.debug("Writing credentials file to {}", (Object)this.file);
        File tempFile = new File(this.file.getPath() + ".tmp");
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), PcsUtils.UTF8);
            for (String key : this.credentialsMap.keySet()) {
                Credentials cred = this.credentialsMap.get(key);
                String line = key + "=" + cred.toJson() + "\n";
                writer.write(line);
            }
            ((Writer)writer).flush();
        }
        catch (Throwable throwable) {
            PcsUtils.closeQuietly(writer);
            throw throwable;
        }
        PcsUtils.closeQuietly(writer);
        this.file.delete();
        tempFile.renameTo(this.file);
    }

    private String getUserKey(AppInfo appInfo, String userId) {
        if (userId == null) {
            throw new IllegalArgumentException("userId should not be null");
        }
        return String.format("%s%s", this.getAppPrefix(appInfo), userId);
    }

    private String getAppPrefix(AppInfo appInfo) {
        return String.format("%s.%s.", appInfo.getProviderName(), appInfo.getAppName());
    }

    public String toString() {
        return "UserCredentialsRepo{file='" + this.file + '\'' + ", credentialsMap=" + this.credentialsMap + '}';
    }
}

