/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.exceptions;

import net.netheos.pcsapi.exceptions.CStorageException;
import net.netheos.pcsapi.request.CResponse;
import net.netheos.pcsapi.utils.PcsUtils;

public class CHttpException
extends CStorageException {
    private final String requestMethod;
    private final String requestUri;
    private final int status;
    private final String reason;

    public CHttpException(String message, CResponse response) {
        super(message);
        this.requestMethod = response.getMethod();
        this.requestUri = PcsUtils.shortenUrl(response.getUri());
        this.status = response.getStatus();
        this.reason = response.getReason();
    }

    public int getStatus() {
        return this.status;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{ " + this.requestMethod + " " + this.requestUri + " [" + this.status + "/" + this.reason + "] " + this.getMessage() + " }";
    }
}

