/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.models;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CMetadata {
    private final Map<String, String> map = new HashMap<String, String>();

    public CMetadata(Map<String, String> metadata) {
        this.map.putAll(metadata);
    }

    public CMetadata() {
    }

    public void put(String key, String value) throws IllegalArgumentException {
        if (!key.matches("[a-z-]*")) {
            throw new IllegalArgumentException("The key must contains letters and dash");
        }
        for (char c : value.toCharArray()) {
            if (c >= ' ' && c <= '\u007f') continue;
            throw new IllegalArgumentException("The metadata value is not ASCII encoded");
        }
        this.map.put(key, value);
    }

    public String get(String key) {
        return this.map.get(key);
    }

    public Map<String, String> getMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof CMetadata) {
            CMetadata meta = (CMetadata)obj;
            return ((Object)this.map).equals(meta.map);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (this.map != null ? ((Object)this.map).hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.map.toString();
    }
}

