/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.models;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.netheos.pcsapi.utils.URIUtil;

public class CPath {
    public static final CPath ROOT = new CPath("/");
    private static final char FORBIDDEN_CHAR = '\\';
    private final String pathName;

    public CPath(String pathName) {
        this.check(pathName);
        this.pathName = CPath.normalize(pathName);
    }

    private static String normalize(String pathName) {
        pathName = pathName.replaceAll("/+", "/");
        if (!(pathName = pathName.replaceAll("(.+)/$", "$1")).startsWith("/")) {
            pathName = "/" + pathName;
        }
        return pathName;
    }

    private void check(String pathName) {
        for (char c : pathName.toCharArray()) {
            if (c >= ' ' && '\\' != c) continue;
            throw new IllegalArgumentException("Pathname contains invalid char " + c + " : " + pathName);
        }
        for (String comp : pathName.split("/")) {
            if (comp.trim().equals(comp)) continue;
            throw new IllegalArgumentException("Pathname contains leading or trailing spaces : " + pathName);
        }
    }

    public String getUrlEncoded() {
        try {
            return URIUtil.encodePath(this.pathName);
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("Error getting encoded path", ex);
        }
    }

    public String getBaseName() {
        int lastIndex = this.pathName.lastIndexOf(47);
        return this.pathName.substring(lastIndex + 1);
    }

    public boolean isRoot() {
        return this.pathName.equals("/");
    }

    public List<String> split() {
        if (this.isRoot()) {
            return Collections.EMPTY_LIST;
        }
        String path = this.pathName;
        if (this.pathName.startsWith("/")) {
            path = this.pathName.substring(1);
        }
        return Arrays.asList(path.split("/"));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof CPath) {
            CPath path = (CPath)obj;
            return path.pathName.equals(this.pathName) || this.isRoot() && path.isRoot();
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.pathName != null ? this.pathName.hashCode() : 0);
        return hash;
    }

    public String getPathName() {
        return this.pathName;
    }

    public String toString() {
        return this.pathName;
    }

    public CPath getParent() {
        int lastIndex = this.pathName.lastIndexOf(47);
        if (lastIndex == 0) {
            return ROOT;
        }
        return new CPath(this.pathName.substring(0, lastIndex));
    }

    public CPath add(String baseName) {
        return new CPath(this.pathName + '/' + baseName);
    }
}

