/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.models;

import net.netheos.pcsapi.bytesio.ByteSource;
import net.netheos.pcsapi.bytesio.ProgressByteSource;
import net.netheos.pcsapi.bytesio.ProgressListener;
import net.netheos.pcsapi.models.CMetadata;
import net.netheos.pcsapi.models.CPath;

public class CUploadRequest {
    private final CPath path;
    private final ByteSource byteSource;
    private String contentType;
    private CMetadata metadata;
    private ProgressListener progressListener;

    public CUploadRequest(CPath path, ByteSource byteSource) {
        this.path = path;
        this.byteSource = byteSource;
    }

    public CPath getPath() {
        return this.path;
    }

    public String getContentType() {
        return this.contentType;
    }

    public CUploadRequest setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public CMetadata getMetadata() {
        return this.metadata;
    }

    public CUploadRequest setMetadata(CMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public CUploadRequest setProgressListener(ProgressListener pl) {
        this.progressListener = pl;
        return this;
    }

    public ByteSource getByteSource() {
        ByteSource bs = this.byteSource;
        if (this.progressListener != null) {
            bs = new ProgressByteSource(bs, this.progressListener);
        }
        return bs;
    }

    public String toString() {
        return "CUploadRequest{path=" + this.path + ", contentType='" + this.contentType + '\'' + ", metadata='" + this.metadata + '\'' + '}';
    }
}

