/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.models;

import java.util.concurrent.Callable;
import net.netheos.pcsapi.exceptions.CRetriableException;
import net.netheos.pcsapi.exceptions.CStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryStrategy.class);
    private final int nbTriesMax;
    private final long firstSleep_ms;

    public RetryStrategy(int nbTriesMax, long firstSleep_ms) {
        this.nbTriesMax = nbTriesMax;
        this.firstSleep_ms = firstSleep_ms;
    }

    /*
     * Loose catch block
     */
    public <T> T invokeRetry(Callable<T> invoker) throws CStorageException {
        int currentTries = 0;
        while (true) {
            ++currentTries;
            try {
                LOGGER.debug("Invokation #{}", (Object)currentTries);
                return invoker.call();
            }
            catch (CRetriableException ex) {
                if (currentTries >= this.nbTriesMax) {
                    LOGGER.debug("Aborting invocation after {} attempts", (Object)this.nbTriesMax);
                    Throwable cause = ex.getCause();
                    if (cause instanceof CStorageException) {
                        throw (CStorageException)cause;
                    }
                    throw new CStorageException("Invocation failure", cause);
                }
                LOGGER.debug("Catching a CRetriableException, {} out of {} max attempts", (Object)currentTries, (Object)this.nbTriesMax);
                this.doWait(currentTries, ex.getDelay());
                continue;
            }
            catch (CStorageException ex) {
                throw ex;
            }
            break;
        }
        catch (Exception ex) {
            throw new CStorageException("Invocation failure", ex);
        }
    }

    private void doWait(int currentTries, long optDuration_ms) {
        if (optDuration_ms < 0L) {
            optDuration_ms = (long)((double)this.firstSleep_ms * (Math.random() + 0.5) * (double)(1L << currentTries - 1));
        }
        LOGGER.debug("Will retry request after {} millis", (Object)optDuration_ms);
        try {
            Thread.sleep(optDuration_ms);
        }
        catch (InterruptedException ex) {
            throw new CStorageException("Retry waiting interrupted", ex);
        }
    }
}

