/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.oauth;

import java.io.IOException;
import java.net.URI;
import net.netheos.pcsapi.credentials.OAuth2AppInfo;
import net.netheos.pcsapi.credentials.UserCredentials;
import net.netheos.pcsapi.exceptions.CStorageException;
import net.netheos.pcsapi.oauth.OAuth2SessionManager;
import net.netheos.pcsapi.storage.IStorageProvider;
import net.netheos.pcsapi.storage.StorageProvider;
import net.netheos.pcsapi.utils.PcsUtils;
import net.netheos.pcsapi.utils.URIBuilder;
import net.netheos.pcsapi.utils.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Bootstrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2Bootstrapper.class);
    private final StorageProvider storageProvider;
    private final OAuth2SessionManager sessionManager;
    private String state;

    public OAuth2Bootstrapper(IStorageProvider storageProvider) {
        this.storageProvider = (StorageProvider)storageProvider;
        if (!(this.storageProvider.getSessionManager() instanceof OAuth2SessionManager)) {
            throw new CStorageException("This provider does not use OAuth2 authentication");
        }
        this.sessionManager = (OAuth2SessionManager)this.storageProvider.getSessionManager();
    }

    public URI getAuthorizeBrowserUrl() {
        OAuth2AppInfo appInfo = this.sessionManager.getAppInfo();
        this.state = PcsUtils.randomString(30);
        URI uri = new URIBuilder(URI.create(this.sessionManager.getAuthorizeUrl())).addParameter("client_id", appInfo.getAppId()).addParameter("state", this.state).addParameter("response_type", "code").addParameter("redirect_uri", appInfo.getRedirectUrl()).addParameter("scope", this.sessionManager.getScopeForAuthorization()).build();
        return uri;
    }

    public void getUserCredentials(String codeOrUrl) throws IOException {
        String code;
        if (this.state == null) {
            throw new IllegalStateException("No anti CSRF state defined");
        }
        if (codeOrUrl.startsWith("http://") || codeOrUrl.startsWith("https://")) {
            String url = codeOrUrl;
            LOGGER.debug("redirect URL: {}", (Object)url);
            URI uri = URI.create(url);
            String error = URIUtil.getQueryParameter(uri, "error");
            String errorDescription = URIUtil.getQueryParameter(uri, "error_description");
            if (error != null) {
                String msg = "User authorization failed : " + error;
                if (errorDescription != null) {
                    msg = msg + " (" + errorDescription + ")";
                }
                throw new CStorageException(msg);
            }
            String stateToTest = URIUtil.getQueryParameter(uri, "state");
            if (!this.state.equals(stateToTest)) {
                throw new CStorageException("State received (" + stateToTest + ") is not state expected (" + this.state + ")");
            }
            code = URIUtil.getQueryParameter(uri, "code");
            if (code == null) {
                throw new CStorageException("Can't find code in redirected URL: " + url);
            }
        } else {
            code = codeOrUrl;
        }
        UserCredentials userCredentials = this.sessionManager.fetchUserCredentials(code);
        String userId = this.storageProvider.getUserId();
        LOGGER.debug("User identifier retrieved: {}", (Object)userId);
        userCredentials.setUserId(userId);
        this.sessionManager.getUserCredentialsRepository().save(userCredentials);
    }
}

