/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.oauth;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.netheos.pcsapi.credentials.PasswordCredentials;
import net.netheos.pcsapi.credentials.UserCredentialsRepository;
import net.netheos.pcsapi.exceptions.CRetriableException;
import net.netheos.pcsapi.oauth.SessionManager;
import net.netheos.pcsapi.request.CResponse;
import net.netheos.pcsapi.storage.StorageBuilder;
import net.netheos.pcsapi.utils.PcsUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordSessionManager
extends SessionManager<PasswordCredentials> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordSessionManager.class);
    private final UserCredentialsRepository userCredentialsRepo;
    private final HttpClient httpClient;
    private final UsernamePasswordCredentials usernamePasswordCredentials;
    private final Map<HttpHost, ThreadLocal<HttpContext>> cache = new HashMap<HttpHost, ThreadLocal<HttpContext>>();

    public PasswordSessionManager(StorageBuilder builder) {
        super(builder.getUserCredentials());
        PasswordCredentials credentials;
        this.httpClient = builder.getHttpClient();
        this.userCredentialsRepo = builder.getUserCredentialsRepo();
        this.usernamePasswordCredentials = new UsernamePasswordCredentials(this.userCredentials.getUserId(), ((PasswordCredentials)this.userCredentials.getCredentials()).getPassword());
        if (this.userCredentials != null && (credentials = (PasswordCredentials)this.userCredentials.getCredentials()).getPassword() == null) {
            throw new IllegalStateException("User credentials do not contain any password");
        }
    }

    @Override
    public CResponse execute(HttpUriRequest request) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}: {}", (Object)request.getMethod(), (Object)PcsUtils.shortenUrl(request.getURI()));
        }
        try {
            URI uri = request.getURI();
            HttpHost host = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            HttpContext context = this.getHttpContext(host);
            HttpResponse httpResponse = this.httpClient.execute(host, (HttpRequest)request, context);
            return new CResponse(request, httpResponse);
        }
        catch (IOException ex) {
            throw new CRetriableException(ex);
        }
    }

    private synchronized HttpContext getHttpContext(HttpHost host) {
        HttpContext context;
        ThreadLocal<Object> tlContext = this.cache.get(host);
        if (tlContext == null) {
            tlContext = new ThreadLocal();
            this.cache.put(host, tlContext);
        }
        if ((context = tlContext.get()) == null) {
            AuthScope scope = new AuthScope(host.getHostName(), host.getPort());
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(scope, (Credentials)this.usernamePasswordCredentials);
            context = new BasicHttpContext();
            context.setAttribute("http.auth.credentials-provider", (Object)credentialsProvider);
            tlContext.set(context);
        }
        return context;
    }

    UserCredentialsRepository getUserCredentialsRepository() {
        return this.userCredentialsRepo;
    }
}

