/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.providers.cloudme;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.netheos.pcsapi.models.CFolder;
import net.netheos.pcsapi.models.CPath;

public class CMFolder
implements Iterable<CMFolder> {
    private String id;
    private String name;
    private CMFolder parent;
    private Map<String, CMFolder> children;

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public CMFolder(String id, String name) {
        this.id = id;
        this.name = name;
        this.children = new HashMap<String, CMFolder>();
    }

    public CMFolder addChild(String id, String name) {
        CMFolder childFolder = new CMFolder(id, name);
        childFolder.parent = this;
        this.children.put(name, childFolder);
        return childFolder;
    }

    @Override
    public Iterator<CMFolder> iterator() {
        return this.children.values().iterator();
    }

    public CMFolder getChildByName(String name) {
        return this.children.get(name);
    }

    public CMFolder getFolder(CPath path) {
        List<String> baseNames = path.split();
        if (path.isRoot()) {
            return this;
        }
        CMFolder currentFolder = this;
        CMFolder subFolder = null;
        for (String baseName : baseNames) {
            subFolder = currentFolder.getChildByName(baseName);
            if (subFolder == null) {
                return null;
            }
            currentFolder = subFolder;
        }
        return subFolder;
    }

    public CPath getCPath() {
        if (this.parent == null) {
            return CPath.ROOT;
        }
        CMFolder currentFolder = this;
        StringBuilder path = new StringBuilder();
        while (currentFolder.parent != null) {
            path.insert(0, currentFolder.name);
            path.insert(0, '/');
            currentFolder = currentFolder.parent;
        }
        return new CPath(path.toString());
    }

    public CFolder toCFolder() {
        return new CFolder(this.getCPath());
    }
}

