/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.providers.cloudme;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.netheos.pcsapi.exceptions.CFileNotFoundException;
import net.netheos.pcsapi.exceptions.CInvalidFileTypeException;
import net.netheos.pcsapi.exceptions.CRetriableException;
import net.netheos.pcsapi.exceptions.CStorageException;
import net.netheos.pcsapi.models.CBlob;
import net.netheos.pcsapi.models.CDownloadRequest;
import net.netheos.pcsapi.models.CFile;
import net.netheos.pcsapi.models.CFolder;
import net.netheos.pcsapi.models.CFolderContent;
import net.netheos.pcsapi.models.CPath;
import net.netheos.pcsapi.models.CQuota;
import net.netheos.pcsapi.models.CUploadRequest;
import net.netheos.pcsapi.oauth.PasswordSessionManager;
import net.netheos.pcsapi.providers.cloudme.CMBlob;
import net.netheos.pcsapi.providers.cloudme.CMFolder;
import net.netheos.pcsapi.request.ByteSourceBody;
import net.netheos.pcsapi.request.CResponse;
import net.netheos.pcsapi.request.CloudMeMultipartEntity;
import net.netheos.pcsapi.request.HttpRequestor;
import net.netheos.pcsapi.request.RequestInvoker;
import net.netheos.pcsapi.request.ResponseValidator;
import net.netheos.pcsapi.storage.StorageBuilder;
import net.netheos.pcsapi.storage.StorageProvider;
import net.netheos.pcsapi.utils.PcsUtils;
import net.netheos.pcsapi.utils.XmlUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CloudMe
extends StorageProvider<PasswordSessionManager> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudMe.class);
    public static final String PROVIDER_NAME = "cloudme";
    private static final String BASE_URL = "https://www.cloudme.com/v1";
    private static final String SOAP_HEADER = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" SOAP-ENV:encodingStyle=\"\" xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/1999/XMLSchema\"><SOAP-ENV:Body>";
    private static final String SOAP_FOOTER = "</SOAP-ENV:Body></SOAP-ENV:Envelope>";
    private static final ResponseValidator<CResponse> BASIC_RESPONSE_VALIDATOR = new BasicResponseValidator();
    private static final ResponseValidator<CResponse> API_RESPONSE_VALIDATOR = new ApiResponseValidator(BASIC_RESPONSE_VALIDATOR);
    private String rootId;

    public CloudMe(StorageBuilder builder) {
        super(PROVIDER_NAME, new PasswordSessionManager(builder), builder.getRetryStrategy(), builder.getHttpClient());
    }

    private RequestInvoker<CResponse> getApiRequestInvoker(HttpRequestBase request, CPath path) {
        return new RequestInvoker<CResponse>(new HttpRequestor((HttpUriRequest)request, path, this.sessionManager), API_RESPONSE_VALIDATOR);
    }

    private RequestInvoker<CResponse> getBasicRequestInvoker(HttpRequestBase request, CPath path) {
        return new RequestInvoker<CResponse>(new HttpRequestor((HttpUriRequest)request, path, this.sessionManager), BASIC_RESPONSE_VALIDATOR);
    }

    @Override
    public String getUserId() throws CStorageException {
        return this.getLogin().getElementsByTagName("username").item(0).getTextContent();
    }

    private Document getLogin() throws CStorageException {
        HttpPost request = this.buildSoapRequest("login", "");
        CResponse response = this.retryStrategy.invokeRetry(this.getApiRequestInvoker((HttpRequestBase)request, null));
        return response.asDom();
    }

    @Override
    public CQuota getQuota() throws CStorageException {
        Document dom = this.getLogin();
        long used = this.getLongFromDom(dom, "currentSize");
        long limit = this.getLongFromDom(dom, "quotaLimit");
        return new CQuota(used, limit);
    }

    @Override
    public CFolderContent listRootFolder() throws CInvalidFileTypeException {
        return this.listFolder(CPath.ROOT);
    }

    private long getLongFromDom(Document dom, String tag) {
        return Long.parseLong(dom.getElementsByTagName(tag).item(0).getTextContent());
    }

    private List<CMBlob> listBlobs(CMFolder cmFolder) throws ParseException {
        HttpPost request = this.buildSoapRequest("queryFolder", "<folder id='" + cmFolder.getId() + "'/>");
        CResponse response = this.retryStrategy.invokeRetry(this.getApiRequestInvoker((HttpRequestBase)request, cmFolder.getCPath()));
        Document dom = response.asDom();
        NodeList elementList = dom.getElementsByTagNameNS("*", "entry");
        ArrayList<CMBlob> cmBlobs = new ArrayList<CMBlob>();
        for (int i = 0; i < elementList.getLength(); ++i) {
            Element element = (Element)elementList.item(i);
            cmBlobs.add(CMBlob.buildCMFile(cmFolder, element));
        }
        return cmBlobs;
    }

    private CMBlob getBlobByName(CMFolder cmFolder, String baseName) throws ParseException {
        StringBuilder innerXml = new StringBuilder();
        innerXml.append("<folder id=").append("'").append(cmFolder.getId()).append("'").append("/>").append("<query>").append("\"").append(XmlUtils.escape(baseName)).append("\"").append("</query>").append("<count>1</count>");
        HttpPost request = this.buildSoapRequest("queryFolder", innerXml.toString());
        CResponse response = this.retryStrategy.invokeRetry(this.getApiRequestInvoker((HttpRequestBase)request, cmFolder.getCPath()));
        Document dom = response.asDom();
        NodeList elementList = dom.getElementsByTagNameNS("*", "entry");
        if (elementList.getLength() == 0) {
            return null;
        }
        CMBlob cmBlob = CMBlob.buildCMFile(cmFolder, (Element)elementList.item(0));
        return cmBlob;
    }

    private CMFolder loadFoldersStructure() {
        CMFolder rootFolder = new CMFolder(this.getRootId(), "root");
        HttpPost request = this.buildSoapRequest("getFolderXML", "<folder id='" + rootFolder.getId() + "'/>");
        CResponse response = this.retryStrategy.invokeRetry(this.getApiRequestInvoker((HttpRequestBase)request, null));
        Element rootElement = this.findRootFolderElement(response.asDom());
        this.scanFolderLevel(rootElement, rootFolder);
        return rootFolder;
    }

    private Element findRootFolderElement(Document dom) {
        NodeList list = dom.getElementsByTagNameNS("*", "folder");
        String localRootId = this.getRootId();
        for (int i = 0; i < list.getLength(); ++i) {
            Element e = (Element)list.item(i);
            if (!e.getAttribute("id").equals(localRootId)) continue;
            return e;
        }
        throw new CStorageException("Could not find root folder with id=" + localRootId);
    }

    private void scanFolderLevel(Element element, CMFolder cmFolder) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element currentElement;
            Node currentNode = nodeList.item(i);
            if (currentNode.getNodeType() != 1 || !(currentElement = (Element)currentNode).getLocalName().equals("folder")) continue;
            CMFolder childFolder = cmFolder.addChild(currentElement.getAttribute("id"), currentElement.getAttribute("name"));
            this.scanFolderLevel(currentElement, childFolder);
        }
    }

    @Override
    public CFolderContent listFolder(CPath cpath) throws CStorageException {
        CMFolder cmRoot = this.loadFoldersStructure();
        CMFolder cmFolder = cmRoot.getFolder(cpath);
        if (cmFolder == null) {
            CMFolder cmParentFolder = cmRoot.getFolder(cpath.getParent());
            if (cmParentFolder != null) {
                CMBlob cmBlob;
                try {
                    cmBlob = this.getBlobByName(cmParentFolder, cpath.getBaseName());
                }
                catch (ParseException e) {
                    throw new CStorageException("Can't parse blob at " + cpath, e);
                }
                if (cmBlob != null) {
                    throw new CInvalidFileTypeException(cpath, false);
                }
            }
            return null;
        }
        List<CMBlob> cmBlobs = null;
        try {
            cmBlobs = this.listBlobs(cmFolder);
        }
        catch (ParseException e) {
            throw new CStorageException(e.getMessage(), e);
        }
        HashMap<CPath, CFile> map = new HashMap<CPath, CFile>();
        for (CMFolder childFolder : cmFolder) {
            CFolder cFile = childFolder.toCFolder();
            map.put(cFile.getPath(), cFile);
        }
        for (CMBlob cmBLob : cmBlobs) {
            CBlob cBlob = cmBLob.toCBlob();
            map.put(cBlob.getPath(), cBlob);
        }
        return new CFolderContent(map);
    }

    private String getRootId() {
        if (this.rootId == null) {
            this.rootId = this.getLogin().getElementsByTagName("home").item(0).getTextContent();
        }
        return this.rootId;
    }

    @Override
    public CFolderContent listFolder(CFolder folder) throws CStorageException {
        return this.listFolder(folder.getPath());
    }

    @Override
    public boolean createFolder(CPath cpath) throws CStorageException {
        if (cpath.isRoot()) {
            return false;
        }
        CMFolder cmRoot = this.loadFoldersStructure();
        CMFolder cmFolder = cmRoot.getFolder(cpath);
        if (cmFolder != null) {
            return false;
        }
        cmFolder = this.createIntermediaryFolders(cmRoot, cpath);
        return cmFolder != null;
    }

    private CMFolder createIntermediaryFolders(CMFolder cmRoot, CPath cpath) {
        List<String> baseNames = cpath.split();
        CMFolder currentFolder = cmRoot;
        CMFolder childFolder = null;
        boolean firstFolderCreation = true;
        for (String baseName : baseNames) {
            childFolder = currentFolder.getChildByName(baseName);
            if (childFolder == null) {
                if (firstFolderCreation) {
                    try {
                        CMBlob cmBlob = this.getBlobByName(currentFolder, baseName);
                        if (cmBlob != null) {
                            throw new CInvalidFileTypeException(cmBlob.getPath(), false);
                        }
                    }
                    catch (ParseException e) {
                        throw new CStorageException(e.getMessage(), e);
                    }
                    firstFolderCreation = false;
                }
                childFolder = this.rawCreateFolder(currentFolder, baseName);
            }
            currentFolder = childFolder;
        }
        return childFolder;
    }

    private CMFolder rawCreateFolder(CMFolder cmParentFolder, String name) {
        StringBuilder innerXml = new StringBuilder();
        innerXml.append("<folder id='").append(cmParentFolder.getId()).append("'/>");
        innerXml.append("<childFolder>").append(XmlUtils.escape(name)).append("</childFolder>");
        HttpPost request = this.buildSoapRequest("newFolder", innerXml.toString());
        CResponse response = this.retryStrategy.invokeRetry(this.getApiRequestInvoker((HttpRequestBase)request, null));
        Document dom = response.asDom();
        String newFolderId = dom.getElementsByTagNameNS("*", "newFolderId").item(0).getTextContent();
        return cmParentFolder.addChild(newFolderId, name);
    }

    @Override
    public boolean delete(CPath cpath) throws CStorageException {
        if (cpath.isRoot()) {
            throw new CStorageException("Can't delete root folder");
        }
        CMFolder cmRoot = this.loadFoldersStructure();
        CMFolder cmParentFolder = cmRoot.getFolder(cpath.getParent());
        if (cmParentFolder == null) {
            return false;
        }
        CMFolder cmFolder = cmParentFolder.getChildByName(cpath.getBaseName());
        if (cmFolder != null) {
            StringBuilder innerXml = new StringBuilder();
            innerXml.append("<folder id='").append(cmParentFolder.getId()).append("'/>");
            innerXml.append("<childFolder id='").append(cmFolder.getId()).append("'/>");
            HttpPost request = this.buildSoapRequest("deleteFolder", innerXml.toString());
            CResponse response = this.retryStrategy.invokeRetry(this.getApiRequestInvoker((HttpRequestBase)request, null));
            String result = response.asDom().getElementsByTagNameNS("*", "deleteFolderResponse").item(0).getTextContent();
            return result.trim().equalsIgnoreCase("OK");
        }
        try {
            CMBlob cmBlob = this.getBlobByName(cmParentFolder, cpath.getBaseName());
            if (cmBlob == null) {
                return false;
            }
            StringBuilder innerXml = new StringBuilder("<folder id='").append(cmParentFolder.getId()).append("'/>");
            innerXml.append("<document id='").append(cmBlob.getId()).append("'/>");
            HttpPost request = this.buildSoapRequest("deleteDocument", innerXml.toString());
            CResponse response = this.retryStrategy.invokeRetry(this.getApiRequestInvoker((HttpRequestBase)request, null));
            String result = response.asDom().getElementsByTagNameNS("*", "deleteDocumentResponse").item(0).getTextContent();
            return result.trim().equalsIgnoreCase("OK");
        }
        catch (ParseException e) {
            throw new CStorageException(e.getMessage(), e);
        }
    }

    @Override
    public CFile getFile(CPath cpath) throws CStorageException {
        CMFolder cmRoot = this.loadFoldersStructure();
        CMFolder cmParentFolder = cmRoot.getFolder(cpath.getParent());
        if (cmParentFolder == null) {
            return null;
        }
        CMFolder cmFolder = cmParentFolder.getChildByName(cpath.getBaseName());
        if (cmFolder != null) {
            return new CFolder(cmParentFolder.getCPath().add(cpath.getBaseName()));
        }
        try {
            CMBlob cmBlob = this.getBlobByName(cmParentFolder, cpath.getBaseName());
            if (cmBlob == null) {
                return null;
            }
            return cmBlob.toCBlob();
        }
        catch (ParseException e) {
            throw new CStorageException(e.getMessage(), e);
        }
    }

    @Override
    public void download(CDownloadRequest downloadRequest) throws CStorageException {
        CPath path = downloadRequest.getPath();
        CMFolder cmRoot = this.loadFoldersStructure();
        CMFolder cmParentFolder = cmRoot.getFolder(path.getParent());
        if (cmParentFolder == null) {
            throw new CFileNotFoundException("This file does not exist", downloadRequest.getPath());
        }
        CMFolder cmFolder = cmParentFolder.getChildByName(path.getBaseName());
        if (cmFolder != null) {
            throw new CInvalidFileTypeException(downloadRequest.getPath(), true);
        }
        try {
            CMBlob cmBlob = this.getBlobByName(cmParentFolder, path.getBaseName());
            if (cmBlob == null) {
                throw new CFileNotFoundException("Can't download this file, it does not exist", path);
            }
            String url = this.buildRestUrl("documents") + cmParentFolder.getId() + '/' + cmBlob.getId() + "/1";
            URI uri = URI.create(url);
            HttpGet request = new HttpGet(uri);
            for (Header header : downloadRequest.getHttpHeaders()) {
                request.addHeader(header);
            }
            RequestInvoker<CResponse> invoker = this.getBasicRequestInvoker((HttpRequestBase)request, downloadRequest.getPath());
            CResponse response = this.retryStrategy.invokeRetry(invoker);
            PcsUtils.downloadDataToSink(response, downloadRequest.getByteSink());
        }
        catch (ParseException e) {
            throw new CStorageException(e.getMessage(), e);
        }
    }

    @Override
    public void upload(CUploadRequest ur) throws CStorageException {
        CPath path = ur.getPath();
        CMFolder cmRoot = this.loadFoldersStructure();
        CMFolder cmParentFolder = cmRoot.getFolder(path.getParent());
        if (cmParentFolder == null) {
            cmParentFolder = this.createIntermediaryFolders(cmRoot, path.getParent());
        } else {
            CMFolder cmFolder = cmParentFolder.getChildByName(path.getBaseName());
            if (cmFolder != null) {
                throw new CInvalidFileTypeException(path, true);
            }
        }
        String url = this.buildRestUrl("documents") + cmParentFolder.getId();
        URI uri = URI.create(url);
        HttpPost request = new HttpPost(uri);
        try {
            ByteSourceBody bsBody = new ByteSourceBody(ur.getByteSource(), path.getBaseName(), ur.getContentType());
            CloudMeMultipartEntity reqEntity = new CloudMeMultipartEntity();
            reqEntity.addPart("bin", (ContentBody)bsBody);
            request.setEntity((HttpEntity)reqEntity);
            RequestInvoker<CResponse> invoker = this.getBasicRequestInvoker((HttpRequestBase)request, ur.getPath());
            CResponse response = this.retryStrategy.invokeRetry(invoker);
            response.close();
        }
        catch (IOException ex) {
            throw new CStorageException("Can't close stream", ex);
        }
    }

    private String buildRestUrl(String methodPath) {
        return "https://www.cloudme.com/v1/" + methodPath + '/';
    }

    private HttpPost buildSoapRequest(String action, String innerXml) {
        StringEntity entity;
        HttpPost httpPost = new HttpPost(BASE_URL);
        httpPost.setHeader("soapaction", action);
        httpPost.setHeader("Content-Type", "text/xml; charset=utf-8");
        StringBuilder soap = new StringBuilder();
        soap.append(SOAP_HEADER);
        soap.append("<").append(action).append(">");
        soap.append(innerXml);
        soap.append("</").append(action).append(">");
        soap.append(SOAP_FOOTER);
        try {
            entity = new StringEntity(soap.toString(), PcsUtils.UTF8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new CStorageException(e.getMessage(), e);
        }
        httpPost.setEntity((HttpEntity)entity);
        return httpPost;
    }

    private static class BasicResponseValidator
    implements ResponseValidator<CResponse> {
        private BasicResponseValidator() {
        }

        @Override
        public void validateResponse(CResponse response, CPath path) throws CStorageException {
            int status = response.getStatus();
            if (status >= 300) {
                throw this.buildCHttpException(response, path);
            }
        }

        private CStorageException buildCHttpException(CResponse response, CPath cpath) {
            String stringResponse = response.asString();
            String message = null;
            boolean retriable = false;
            String ct = response.getContentType();
            if (ct.contains("application/xml") || ct.contains("text/xml")) {
                Document dom = XmlUtils.getDomFromString(stringResponse);
                NodeList faultCodeElements = dom.getElementsByTagNameNS("*", "faultcode");
                if (faultCodeElements.getLength() > 0) {
                    Element errorElement;
                    NodeList errorElements;
                    NodeList faultStringElements;
                    String faultCode = faultCodeElements.item(0).getTextContent();
                    if (faultCode.equals("SOAP-ENV:Client") && (faultStringElements = dom.getElementsByTagNameNS("*", "faultstring")).getLength() > 0) {
                        message = faultStringElements.item(0).getTextContent();
                    }
                    if ((errorElements = dom.getElementsByTagNameNS("*", "error")).getLength() > 0 && !(errorElement = (Element)errorElements.item(0)).getAttribute("code").isEmpty()) {
                        String code = errorElement.getAttribute("code");
                        String reason = errorElement.getAttribute("description");
                        String number = errorElement.getAttribute("number");
                        message = "[" + code + " " + reason + " " + number + "] " + errorElement.getTextContent();
                        if (cpath != null) {
                            message = message + " (" + cpath + ")";
                        }
                        if (code.trim().equals("404")) {
                            return new CFileNotFoundException(message, cpath);
                        }
                    }
                }
            } else {
                LOGGER.error("Unparsable server error: {}", (Object)stringResponse);
                message = PcsUtils.abbreviate("Unparsable server error: " + stringResponse, 200);
                LOGGER.error("Unparsable server error has headers: {}", (Object)response.getHeaders());
                if (response.getStatus() >= 500) {
                    retriable = true;
                }
            }
            CStorageException ret = PcsUtils.buildCStorageException(response, message, cpath);
            if (retriable) {
                ret = new CRetriableException(ret);
            }
            return ret;
        }
    }

    private static class ApiResponseValidator
    implements ResponseValidator<CResponse> {
        private final ResponseValidator<CResponse> parent;

        public ApiResponseValidator(ResponseValidator<CResponse> parent) {
            this.parent = parent;
        }

        @Override
        public void validateResponse(CResponse response, CPath path) throws CStorageException {
            this.parent.validateResponse(response, path);
            LOGGER.debug("ValidateResponse - server response OK");
            PcsUtils.ensureContentTypeIsXml(response, true);
            LOGGER.debug("ValidateResponse - all is OK");
        }
    }
}

