/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.providers.googledrive;

import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import net.netheos.pcsapi.exceptions.CAuthenticationException;
import net.netheos.pcsapi.exceptions.CFileNotFoundException;
import net.netheos.pcsapi.exceptions.CInvalidFileTypeException;
import net.netheos.pcsapi.exceptions.CRetriableException;
import net.netheos.pcsapi.exceptions.CStorageException;
import net.netheos.pcsapi.models.CBlob;
import net.netheos.pcsapi.models.CDownloadRequest;
import net.netheos.pcsapi.models.CFile;
import net.netheos.pcsapi.models.CFolder;
import net.netheos.pcsapi.models.CFolderContent;
import net.netheos.pcsapi.models.CPath;
import net.netheos.pcsapi.models.CQuota;
import net.netheos.pcsapi.models.CUploadRequest;
import net.netheos.pcsapi.oauth.OAuth2SessionManager;
import net.netheos.pcsapi.providers.googledrive.RemotePath;
import net.netheos.pcsapi.request.ByteSourceBody;
import net.netheos.pcsapi.request.CResponse;
import net.netheos.pcsapi.request.HttpRequestor;
import net.netheos.pcsapi.request.JSONBody;
import net.netheos.pcsapi.request.JSONEntity;
import net.netheos.pcsapi.request.MultipartRelatedEntity;
import net.netheos.pcsapi.request.RequestInvoker;
import net.netheos.pcsapi.request.ResponseValidator;
import net.netheos.pcsapi.storage.StorageBuilder;
import net.netheos.pcsapi.storage.StorageProvider;
import net.netheos.pcsapi.utils.PcsUtils;
import net.netheos.pcsapi.utils.URIBuilder;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.content.ContentBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleDrive
extends StorageProvider<OAuth2SessionManager> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleDrive.class);
    public static final String PROVIDER_NAME = "googledrive";
    private static final String ENDPOINT = "https://www.googleapis.com/drive/v2";
    private static final String FILES_ENDPOINT = "https://www.googleapis.com/drive/v2/files";
    private static final String FILES_UPLOAD_ENDPOINT = "https://www.googleapis.com/upload/drive/v2/files";
    private static final String USERINFO_ENDPOINT = "https://www.googleapis.com/oauth2/v1/userinfo";
    static final String MIME_TYPE_DIRECTORY = "application/vnd.google-apps.folder";
    private static final ResponseValidator<CResponse> BASIC_VALIDATOR = new DriveResponseValidator();
    private static final ResponseValidator<CResponse> API_VALIDATOR = new ApiResponseValidator(BASIC_VALIDATOR);
    private static final String OAUTH_ROOT = "https://accounts.google.com/o/oauth2";

    public GoogleDrive(StorageBuilder builder) {
        super(PROVIDER_NAME, new OAuth2SessionManager("https://accounts.google.com/o/oauth2/auth?access_type=offline&approval_prompt=force", "https://accounts.google.com/o/oauth2/token", "https://accounts.google.com/o/oauth2/token/", true, Character.valueOf(' '), builder), builder.getRetryStrategy(), builder.getHttpClient());
    }

    private RequestInvoker<CResponse> getBasicRequestInvoker(HttpUriRequest request, CPath path) {
        return new DriveRequestInvoker(new HttpRequestor(request, path, this.sessionManager), BASIC_VALIDATOR);
    }

    private RequestInvoker<CResponse> getApiRequestInvoker(HttpUriRequest request, CPath path) {
        return new DriveRequestInvoker(new HttpRequestor(request, path, this.sessionManager), API_VALIDATOR);
    }

    private CFile parseCFile(CPath parentPath, JSONObject json) {
        String dateStr = json.getString("modifiedDate");
        try {
            CFile cFile;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
            format.setLenient(false);
            if (dateStr.endsWith("Z")) {
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
            }
            Date modified = format.parse(dateStr);
            if (MIME_TYPE_DIRECTORY.equals(json.getString("mimeType"))) {
                cFile = new CFolder(parentPath.add(json.getString("title")), modified, null);
            } else {
                long fileSize = json.has("fileSize") ? json.getLong("fileSize") : -1L;
                cFile = new CBlob(parentPath.add(json.getString("title")), fileSize, json.getString("mimeType"), modified, null);
            }
            return cFile;
        }
        catch (ParseException ex) {
            throw new CStorageException("Can't parse date modified: " + dateStr + " (" + ex.getMessage() + ")", ex);
        }
    }

    private String getFileUrl(String fileId) {
        return "https://www.googleapis.com/drive/v2/files/" + fileId;
    }

    private RemotePath findRemotePath(CPath path, boolean detailed) {
        if (path.isRoot()) {
            return new RemotePath(path, new LinkedList<JSONObject>());
        }
        List<String> segments = path.split();
        StringBuilder query = new StringBuilder("(");
        int i = 0;
        for (String segment : segments) {
            if (i > 0) {
                query.append(" or ");
            }
            query.append("(title='").append(segment.replace("'", "\\'")).append("'");
            query.append(")");
            ++i;
        }
        query.append(") and trashed = false");
        ArrayList<JSONObject> items = new ArrayList<JSONObject>(segments.size());
        String nextPageToken = null;
        while (true) {
            String fieldsFilter = "id,title,mimeType,parents/id,parents/isRoot";
            if (detailed) {
                fieldsFilter = fieldsFilter + ",downloadUrl,modifiedDate,fileSize";
            }
            fieldsFilter = "nextPageToken,items(" + fieldsFilter + ")";
            URIBuilder builder = new URIBuilder(URI.create(FILES_ENDPOINT));
            builder.addParameter("q", query.toString());
            builder.addParameter("fields", fieldsFilter);
            if (nextPageToken != null) {
                builder.addParameter("pageToken", nextPageToken);
            }
            builder.addParameter("maxResults", "1000");
            HttpGet request = new HttpGet(builder.build());
            RequestInvoker<CResponse> ri = this.getApiRequestInvoker((HttpUriRequest)request, null);
            JSONObject jresp = this.retryStrategy.invokeRetry(ri).asJSONObject();
            JSONArray itemsInPage = jresp.getJSONArray("items");
            for (i = 0; i < itemsInPage.length(); ++i) {
                items.add(itemsInPage.getJSONObject(i));
            }
            nextPageToken = jresp.optString("nextPageToken", null);
            if (nextPageToken == null) break;
            LOGGER.debug("findRemotePath() will loop : ({} items in this page)", (Object)itemsInPage.length());
        }
        LOGGER.debug("findRemotePath() : no more data for this query");
        LinkedList<JSONObject> filesChain = new LinkedList<JSONObject>();
        i = 0;
        for (String searchedSegment : segments) {
            boolean firstSegment = i == 0;
            ++i;
            JSONObject nextItem = null;
            for (JSONObject item : items) {
                JSONObject p;
                int k;
                if (!item.getString("title").equals(searchedSegment)) continue;
                JSONArray parents = item.optJSONArray("parents");
                if (firstSegment) {
                    if (parents == null || parents.length() == 0) {
                        nextItem = item;
                        break;
                    }
                    for (k = 0; k < parents.length(); ++k) {
                        p = parents.getJSONObject(k);
                        if (!p.getBoolean("isRoot")) continue;
                        nextItem = item;
                        break;
                    }
                } else {
                    for (k = 0; k < parents.length(); ++k) {
                        p = parents.getJSONObject(k);
                        if (!p.getString("id").equals(filesChain.getLast().getString("id"))) continue;
                        nextItem = item;
                        break;
                    }
                }
                if (nextItem == null) continue;
                break;
            }
            if (nextItem == null) break;
            filesChain.add(nextItem);
        }
        return new RemotePath(path, filesChain);
    }

    @Override
    public String getUserId() throws CStorageException {
        String url = USERINFO_ENDPOINT;
        RequestInvoker<CResponse> ri = this.getApiRequestInvoker((HttpUriRequest)new HttpGet(url), null);
        JSONObject json = this.retryStrategy.invokeRetry(ri).asJSONObject();
        return json.getString("email");
    }

    @Override
    public CQuota getQuota() throws CStorageException {
        String url = "https://www.googleapis.com/drive/v2/about";
        RequestInvoker<CResponse> ri = this.getApiRequestInvoker((HttpUriRequest)new HttpGet(url), null);
        JSONObject json = this.retryStrategy.invokeRetry(ri).asJSONObject();
        return new CQuota(json.getLong("quotaBytesUsed"), json.getLong("quotaBytesTotal"));
    }

    @Override
    public CFolderContent listRootFolder() throws CInvalidFileTypeException {
        return this.listFolder(CPath.ROOT);
    }

    @Override
    public CFolderContent listFolder(CPath path) throws CStorageException {
        RemotePath remotePath = this.findRemotePath(path, true);
        if (!remotePath.exists()) {
            return null;
        }
        if (remotePath.lastIsBlob()) {
            throw new CInvalidFileTypeException(path, false);
        }
        String folderId = remotePath.getDeepestFolderId();
        StringBuilder query = new StringBuilder();
        query.append("('").append(folderId).append("' in parents");
        if (path.isRoot()) {
            query.append(" or sharedWithMe");
        }
        query.append(") and trashed=false");
        String fieldsFilter = "nextPageToken,items(id,title,mimeType,fileSize,modifiedDate)";
        URIBuilder builder = new URIBuilder(URI.create(FILES_ENDPOINT));
        builder.addParameter("q", query.toString());
        builder.addParameter("fields", fieldsFilter);
        HttpGet request = new HttpGet(builder.build());
        RequestInvoker<CResponse> ri = this.getApiRequestInvoker((HttpUriRequest)request, null);
        JSONObject jresp = this.retryStrategy.invokeRetry(ri).asJSONObject();
        HashMap<CPath, CFile> map = new HashMap<CPath, CFile>();
        JSONArray array = jresp.getJSONArray("items");
        for (int i = 0; i < array.length(); ++i) {
            JSONObject itemObj = array.getJSONObject(i);
            CFile file = this.parseCFile(path, itemObj);
            map.put(file.getPath(), file);
        }
        return new CFolderContent(map);
    }

    @Override
    public CFolderContent listFolder(CFolder folder) throws CStorageException {
        return this.listFolder(folder.getPath());
    }

    private String rawCreateFolder(CPath path, String parentId) {
        JSONObject body = new JSONObject();
        body.put("title", (Object)path.getBaseName());
        body.put("mimeType", (Object)MIME_TYPE_DIRECTORY);
        JSONArray ids = new JSONArray();
        JSONObject idObj = new JSONObject();
        idObj.put("id", (Object)parentId);
        ids.put((Object)idObj);
        body.put("parents", (Object)ids);
        HttpPost request = new HttpPost("https://www.googleapis.com/drive/v2/files?fields=id");
        request.setEntity((HttpEntity)new JSONEntity(body));
        RequestInvoker<CResponse> ri = this.getApiRequestInvoker((HttpUriRequest)request, path);
        JSONObject jresp = this.retryStrategy.invokeRetry(ri).asJSONObject();
        return jresp.getString("id");
    }

    @Override
    public boolean createFolder(CPath path) throws CStorageException {
        RemotePath remotePath = this.findRemotePath(path, false);
        if (remotePath.lastIsBlob()) {
            throw new CInvalidFileTypeException(remotePath.lastCPath(), false);
        }
        if (remotePath.exists()) {
            return false;
        }
        String parentId = remotePath.getDeepestFolderId();
        for (int i = remotePath.filesChain.size(); i < remotePath.segments.size(); ++i) {
            CPath currentPath = remotePath.getFirstSegmentsPath(i + 1);
            parentId = this.rawCreateFolder(currentPath, parentId);
        }
        return true;
    }

    private void deleteById(CPath path, String fileId) {
        try {
            String url = this.getFileUrl(fileId) + "/trash";
            HttpPost request = new HttpPost(url);
            RequestInvoker<CResponse> ri = this.getApiRequestInvoker((HttpUriRequest)request, path);
            this.retryStrategy.invokeRetry(ri).close();
        }
        catch (IOException ex) {
            throw new CStorageException("Error deleting file", ex);
        }
    }

    @Override
    public boolean delete(CPath path) throws CStorageException {
        if (path.isRoot()) {
            throw new CStorageException("Can not delete root folder");
        }
        RemotePath remotePath = this.findRemotePath(path, false);
        if (!remotePath.exists()) {
            return false;
        }
        this.deleteById(path, remotePath.filesChain.getLast().getString("id"));
        return true;
    }

    @Override
    public CFile getFile(CPath path) throws CStorageException {
        if (path.isRoot()) {
            return new CFolder(CPath.ROOT);
        }
        RemotePath remotePath = this.findRemotePath(path, true);
        if (!remotePath.exists()) {
            return null;
        }
        return this.parseCFile(path.getParent(), remotePath.filesChain.getLast());
    }

    @Override
    public void download(final CDownloadRequest downloadRequest) throws CStorageException {
        this.retryStrategy.invokeRetry(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CPath path = downloadRequest.getPath();
                RemotePath remotePath = GoogleDrive.this.findRemotePath(path, true);
                if (!remotePath.exists()) {
                    throw new CFileNotFoundException("File not found: " + path, path);
                }
                if (remotePath.exists() && !remotePath.lastIsBlob()) {
                    throw new CInvalidFileTypeException(path, true);
                }
                JSONObject blob = remotePath.getBlob();
                if (!blob.has("downloadUrl")) {
                    if (blob.has("mimeType") && blob.getString("mimeType").startsWith("application/vnd.google-apps.")) {
                        throw new CInvalidFileTypeException("google docs are not downloadable: " + path, path, true);
                    }
                    throw new CStorageException("No downloadUrl defined for blob: " + path);
                }
                String url = blob.getString("downloadUrl");
                HttpGet request = new HttpGet(url);
                for (Header header : downloadRequest.getHttpHeaders()) {
                    request.addHeader(header);
                }
                RequestInvoker ri = GoogleDrive.this.getBasicRequestInvoker((HttpUriRequest)request, path);
                PcsUtils.downloadDataToSink((CResponse)ri.call(), downloadRequest.getByteSink());
                return null;
            }
        });
    }

    @Override
    public void upload(final CUploadRequest uploadRequest) throws CStorageException {
        this.retryStrategy.invokeRetry(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CPath path = uploadRequest.getPath();
                RemotePath remotePath = GoogleDrive.this.findRemotePath(path, false);
                if (remotePath.exists() && !remotePath.lastIsBlob()) {
                    throw new CInvalidFileTypeException(path, true);
                }
                if (!remotePath.exists() && remotePath.lastIsBlob()) {
                    throw new CInvalidFileTypeException(remotePath.lastCPath(), false);
                }
                String fileId = null;
                String parentId = null;
                if (remotePath.exists()) {
                    fileId = remotePath.getBlob().getString("id");
                } else {
                    parentId = remotePath.getDeepestFolderId();
                    for (int i = remotePath.filesChain.size(); i < remotePath.segments.size() - 1; ++i) {
                        CPath currentPath = remotePath.getFirstSegmentsPath(i + 1);
                        parentId = GoogleDrive.this.rawCreateFolder(currentPath, parentId);
                    }
                }
                JSONObject jsonMeta = new JSONObject();
                if (fileId == null) {
                    jsonMeta.put("title", (Object)path.getBaseName());
                    JSONArray idsArray = new JSONArray();
                    JSONObject idObj = new JSONObject();
                    idObj.put("id", (Object)parentId);
                    idsArray.put((Object)idObj);
                    jsonMeta.put("parents", (Object)idsArray);
                }
                if (uploadRequest.getContentType() != null) {
                    jsonMeta.put("mimeType", (Object)uploadRequest.getContentType());
                }
                MultipartRelatedEntity multipart = new MultipartRelatedEntity();
                multipart.addPart("", (ContentBody)new JSONBody(jsonMeta, null));
                multipart.addPart("", (ContentBody)new ByteSourceBody(uploadRequest.getByteSource(), null, uploadRequest.getContentType()));
                Object request = fileId != null ? new HttpPut("https://www.googleapis.com/upload/drive/v2/files/" + fileId + "?uploadType=multipart") : new HttpPost("https://www.googleapis.com/upload/drive/v2/files?uploadType=multipart");
                request.setEntity((HttpEntity)multipart);
                RequestInvoker ri = GoogleDrive.this.getApiRequestInvoker((HttpUriRequest)request, path);
                ((CResponse)ri.call()).close();
                return null;
            }
        });
    }

    private class DriveRequestInvoker
    extends RequestInvoker<CResponse> {
        private boolean alreadyRefreshedToken;

        public DriveRequestInvoker(HttpRequestor requestor, ResponseValidator<CResponse> validator) {
            super(requestor, validator);
            this.alreadyRefreshedToken = false;
        }

        @Override
        protected void validateResponse(CResponse response) {
            try {
                super.validateResponse(response);
            }
            catch (CAuthenticationException ex) {
                LOGGER.warn("Got an unexpected CAuthenticationError : {}", (Object)ex.getMessage());
                if (!this.alreadyRefreshedToken) {
                    LOGGER.warn("Will refresh access_token (in case it is broken?)");
                    ((OAuth2SessionManager)GoogleDrive.this.sessionManager).refreshToken();
                    this.alreadyRefreshedToken = true;
                    throw new CRetriableException(ex, 0L);
                }
                throw ex;
            }
        }
    }

    private static class DriveResponseValidator
    implements ResponseValidator<CResponse> {
        private DriveResponseValidator() {
        }

        @Override
        public void validateResponse(CResponse response, CPath path) throws CStorageException {
            LOGGER.debug("validating googledrive response: {} {} : {} {}", new Object[]{response.getMethod(), response.getUri(), response.getStatus(), response.getReason()});
            if (response.getStatus() >= 300) {
                CStorageException cse = this.buildHttpError(response, path);
                if (response.getStatus() >= 500) {
                    throw new CRetriableException(cse);
                }
                if (response.getStatus() == 403 && cse.getMessage() != null && cse.getMessage().startsWith("[403/rateLimitExceeded]")) {
                    throw new CRetriableException(cse);
                }
                throw cse;
            }
        }

        private CStorageException buildHttpError(CResponse response, CPath path) {
            String message = null;
            String json_str = null;
            try {
                json_str = response.asString();
                JSONObject json = new JSONObject(json_str);
                JSONObject error = json.getJSONObject("error");
                int jcode = error.getInt("code");
                String jreason = error.getJSONArray("errors").getJSONObject(0).getString("reason");
                message = String.format("[%d/%s] ", jcode, jreason);
                message = message + error.getString("message");
                if (jcode == 403 && "userAccess".equals(jreason)) {
                    message = message + " (" + path + ")";
                }
            }
            catch (JSONException ex) {
                LOGGER.warn("Unparsable server error message: {}", (Object)json_str);
            }
            return PcsUtils.buildCStorageException(response, message, path);
        }
    }

    private static class ApiResponseValidator
    implements ResponseValidator<CResponse> {
        private final ResponseValidator<CResponse> parent;

        public ApiResponseValidator(ResponseValidator<CResponse> parent) {
            this.parent = parent;
        }

        @Override
        public void validateResponse(CResponse response, CPath path) throws CStorageException {
            this.parent.validateResponse(response, path);
            LOGGER.debug("ValidateResponse - server response OK");
            PcsUtils.ensureContentTypeIsJson(response, true);
            LOGGER.debug("ValidateResponse - all is OK");
        }
    }
}

