/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.providers.googledrive;

import java.util.LinkedList;
import java.util.List;
import net.netheos.pcsapi.models.CPath;
import org.json.JSONObject;

class RemotePath {
    private final CPath path;
    final List<String> segments;
    final LinkedList<JSONObject> filesChain;

    RemotePath(CPath path, LinkedList<JSONObject> filesChain) {
        this.path = path;
        this.segments = path.split();
        this.filesChain = filesChain;
    }

    public boolean exists() {
        return this.filesChain.size() == this.segments.size();
    }

    public String getDeepestFolderId() {
        if (this.filesChain.isEmpty()) {
            return "root";
        }
        JSONObject last = this.filesChain.getLast();
        if ("application/vnd.google-apps.folder".equals(last.getString("mimeType"))) {
            return last.getString("id");
        }
        if (this.filesChain.size() == 1) {
            return "root";
        }
        return this.filesChain.get(this.filesChain.size() - 2).getString("id");
    }

    public JSONObject getBlob() {
        if (!this.lastIsBlob()) {
            throw new IllegalStateException("Inquiring blob of a folder for " + this.path);
        }
        return this.filesChain.getLast();
    }

    public boolean lastIsBlob() {
        return !this.filesChain.isEmpty() && !"application/vnd.google-apps.folder".equals(this.filesChain.getLast().getString("mimeType"));
    }

    public CPath getFirstSegmentsPath(int depth) {
        StringBuilder sb = new StringBuilder("/");
        for (int i = 0; i < depth && i < this.segments.size(); ++i) {
            sb.append(this.segments.get(i)).append("/");
        }
        return new CPath(sb.toString());
    }

    public CPath lastCPath() {
        return this.getFirstSegmentsPath(this.filesChain.size());
    }
}

