/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.providers.hubic;

import java.util.concurrent.Callable;
import net.netheos.pcsapi.exceptions.CAuthenticationException;
import net.netheos.pcsapi.exceptions.CInvalidFileTypeException;
import net.netheos.pcsapi.exceptions.CRetriableException;
import net.netheos.pcsapi.exceptions.CStorageException;
import net.netheos.pcsapi.models.CDownloadRequest;
import net.netheos.pcsapi.models.CFile;
import net.netheos.pcsapi.models.CFolder;
import net.netheos.pcsapi.models.CFolderContent;
import net.netheos.pcsapi.models.CPath;
import net.netheos.pcsapi.models.CQuota;
import net.netheos.pcsapi.models.CUploadRequest;
import net.netheos.pcsapi.models.RetryStrategy;
import net.netheos.pcsapi.oauth.OAuth2SessionManager;
import net.netheos.pcsapi.providers.hubic.Swift;
import net.netheos.pcsapi.request.CResponse;
import net.netheos.pcsapi.request.HttpExecutor;
import net.netheos.pcsapi.request.HttpRequestor;
import net.netheos.pcsapi.request.RequestInvoker;
import net.netheos.pcsapi.request.Requestor;
import net.netheos.pcsapi.request.ResponseValidator;
import net.netheos.pcsapi.request.SimpleHttpExecutor;
import net.netheos.pcsapi.storage.StorageBuilder;
import net.netheos.pcsapi.storage.StorageProvider;
import net.netheos.pcsapi.utils.PcsUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hubic
extends StorageProvider<OAuth2SessionManager> {
    public static final String PROVIDER_NAME = "hubic";
    private static final Logger LOGGER = LoggerFactory.getLogger(Hubic.class);
    private static final String ROOT = "https://api.hubic.com";
    private static final String ENDPOINT = "https://api.hubic.com/1.0";
    private static final ResponseValidator<CResponse> API_VALIDATOR = new HubicResponseValidator();
    private final HttpExecutor httpExecutor;
    private Swift swiftClient;

    public Hubic(StorageBuilder builder) {
        super(PROVIDER_NAME, new OAuth2SessionManager("https://api.hubic.com/oauth/auth/", "https://api.hubic.com/oauth/token/", "https://api.hubic.com/oauth/token/", true, Character.valueOf(','), builder), builder.getRetryStrategy(), builder.getHttpClient());
        this.httpExecutor = new SimpleHttpExecutor(builder.getHttpClient());
    }

    private RequestInvoker<CResponse> getApiRequestInvoker(HttpUriRequest request) {
        return new HubicRequestInvoker(new HttpRequestor(request, null, this.sessionManager), API_VALIDATOR);
    }

    private synchronized Swift getSwiftClient() throws CStorageException {
        if (this.swiftClient != null) {
            return this.swiftClient;
        }
        String url = "https://api.hubic.com/1.0/account/credentials";
        RequestInvoker<CResponse> ri = this.getApiRequestInvoker((HttpUriRequest)new HttpGet(url));
        JSONObject info = this.retryStrategy.invokeRetry(ri).asJSONObject();
        this.swiftClient = new Swift(info.getString("endpoint"), info.getString("token"), new NoRetryStrategy(), true, this.httpExecutor);
        this.swiftClient.useFirstContainer();
        return this.swiftClient;
    }

    @Override
    public String getUserId() throws CStorageException {
        String url = "https://api.hubic.com/1.0/account";
        RequestInvoker<CResponse> ri = this.getApiRequestInvoker((HttpUriRequest)new HttpGet(url));
        JSONObject json = this.retryStrategy.invokeRetry(ri).asJSONObject();
        return json.getString("email");
    }

    @Override
    public CQuota getQuota() throws CStorageException {
        String url = "https://api.hubic.com/1.0/account/usage";
        RequestInvoker<CResponse> ri = this.getApiRequestInvoker((HttpUriRequest)new HttpGet(url));
        JSONObject json = this.retryStrategy.invokeRetry(ri).asJSONObject();
        return new CQuota(json.getLong("used"), json.getLong("quota"));
    }

    @Override
    public CFolderContent listRootFolder() throws CInvalidFileTypeException {
        return this.listFolder(CPath.ROOT);
    }

    @Override
    public CFolderContent listFolder(final CPath path) throws CStorageException {
        SwiftCaller<CFolderContent> caller = new SwiftCaller<CFolderContent>(path){

            @Override
            protected CFolderContent execute(Swift swiftClient) throws CStorageException {
                return swiftClient.listFolder(path);
            }
        };
        return this.retryStrategy.invokeRetry(caller);
    }

    @Override
    public CFolderContent listFolder(CFolder folder) throws CStorageException {
        return this.listFolder(folder.getPath());
    }

    @Override
    public boolean createFolder(final CPath path) throws CStorageException {
        SwiftCaller<Boolean> caller = new SwiftCaller<Boolean>(path){

            @Override
            protected Boolean execute(Swift swiftClient) throws CStorageException {
                return swiftClient.createFolder(path);
            }
        };
        return this.retryStrategy.invokeRetry(caller);
    }

    @Override
    public boolean delete(final CPath path) throws CStorageException {
        SwiftCaller<Boolean> caller = new SwiftCaller<Boolean>(path){

            @Override
            protected Boolean execute(Swift swiftClient) throws CStorageException {
                return swiftClient.delete(path);
            }
        };
        return this.retryStrategy.invokeRetry(caller);
    }

    @Override
    public CFile getFile(final CPath path) throws CStorageException {
        SwiftCaller<CFile> caller = new SwiftCaller<CFile>(path){

            @Override
            protected CFile execute(Swift swiftClient) throws CStorageException {
                return swiftClient.getFile(path);
            }
        };
        return this.retryStrategy.invokeRetry(caller);
    }

    @Override
    public void download(final CDownloadRequest downloadRequest) throws CStorageException {
        SwiftCaller<Void> caller = new SwiftCaller<Void>(downloadRequest.getPath()){

            @Override
            protected Void execute(Swift swiftClient) throws CStorageException {
                swiftClient.download(downloadRequest);
                return null;
            }
        };
        this.retryStrategy.invokeRetry(caller);
    }

    @Override
    public void upload(final CUploadRequest uploadRequest) throws CStorageException {
        SwiftCaller<Void> caller = new SwiftCaller<Void>(uploadRequest.getPath()){

            @Override
            protected Void execute(Swift swiftClient) throws CStorageException {
                swiftClient.upload(uploadRequest);
                return null;
            }
        };
        this.retryStrategy.invokeRetry(caller);
    }

    private static class NoRetryStrategy
    extends RetryStrategy {
        public NoRetryStrategy() {
            super(1, 0L);
        }

        @Override
        public <T> T invokeRetry(Callable<T> invoker) throws CStorageException {
            try {
                return invoker.call();
            }
            catch (CStorageException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CStorageException("Invocation failure", ex);
            }
        }
    }

    private class HubicRequestInvoker
    extends RequestInvoker<CResponse> {
        private boolean alreadyRefreshedToken;

        public HubicRequestInvoker(HttpRequestor requestor, ResponseValidator<CResponse> validator) {
            super(requestor, validator);
            this.alreadyRefreshedToken = false;
        }

        @Override
        protected void validateResponse(CResponse response) {
            try {
                super.validateResponse(response);
            }
            catch (CAuthenticationException ex) {
                LOGGER.warn("Got an unexpected CAuthenticationError : {}", (Object)ex.getMessage());
                if (!this.alreadyRefreshedToken) {
                    LOGGER.warn("Will refresh access_token (in case it is broken?)");
                    ((OAuth2SessionManager)Hubic.this.sessionManager).refreshToken();
                    this.alreadyRefreshedToken = true;
                    throw new CRetriableException(ex, 0L);
                }
                throw ex;
            }
        }
    }

    private abstract class SwiftCaller<T>
    implements Requestor<T> {
        private final CPath path;

        private SwiftCaller(CPath path) {
            this.path = path;
        }

        @Override
        public T call() throws CStorageException {
            try {
                Swift swiftClient = Hubic.this.getSwiftClient();
                return this.execute(swiftClient);
            }
            catch (CAuthenticationException ex) {
                LOGGER.warn("Swift authentication error : swift client invalidated");
                Hubic.this.swiftClient = null;
                throw new CRetriableException(ex, 0L);
            }
        }

        @Override
        public CPath getPath() {
            return this.path;
        }

        protected abstract T execute(Swift var1) throws CStorageException;
    }

    private static class HubicResponseValidator
    implements ResponseValidator<CResponse> {
        private HubicResponseValidator() {
        }

        @Override
        public void validateResponse(CResponse response, CPath path) throws CStorageException {
            LOGGER.debug("validating hubic response: {} {} : {} {}", new Object[]{response.getMethod(), response.getUri(), response.getStatus(), response.getReason()});
            if (response.getStatus() >= 500) {
                throw new CRetriableException(this.buildHttpError(response, path));
            }
            if (response.getStatus() >= 300) {
                throw this.buildHttpError(response, path);
            }
            PcsUtils.ensureContentTypeIsJson(response, true);
        }

        private CStorageException buildHttpError(CResponse response, CPath path) {
            String serverErrorMsg = null;
            try {
                JSONObject json = response.asJSONObject();
                serverErrorMsg = json.getString("error");
                serverErrorMsg = serverErrorMsg + " (" + json.getString("error_description") + ")";
            }
            catch (JSONException ex) {
            }
            catch (CStorageException ex) {
                // empty catch block
            }
            return PcsUtils.buildCStorageException(response, serverErrorMsg, path);
        }
    }
}

