/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.providers.hubic;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.netheos.pcsapi.bytesio.ByteSource;
import net.netheos.pcsapi.exceptions.CFileNotFoundException;
import net.netheos.pcsapi.exceptions.CInvalidFileTypeException;
import net.netheos.pcsapi.exceptions.CRetriableException;
import net.netheos.pcsapi.exceptions.CStorageException;
import net.netheos.pcsapi.models.CBlob;
import net.netheos.pcsapi.models.CDownloadRequest;
import net.netheos.pcsapi.models.CFile;
import net.netheos.pcsapi.models.CFolder;
import net.netheos.pcsapi.models.CFolderContent;
import net.netheos.pcsapi.models.CMetadata;
import net.netheos.pcsapi.models.CPath;
import net.netheos.pcsapi.models.CUploadRequest;
import net.netheos.pcsapi.models.RetryStrategy;
import net.netheos.pcsapi.request.ByteSourceEntity;
import net.netheos.pcsapi.request.CResponse;
import net.netheos.pcsapi.request.Headers;
import net.netheos.pcsapi.request.HttpExecutor;
import net.netheos.pcsapi.request.HttpRequestor;
import net.netheos.pcsapi.request.RequestInvoker;
import net.netheos.pcsapi.request.ResponseValidator;
import net.netheos.pcsapi.utils.PcsUtils;
import net.netheos.pcsapi.utils.URIBuilder;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Swift {
    private static final Logger LOGGER = LoggerFactory.getLogger(Swift.class);
    private static final ResponseValidator<CResponse> SWIFT_VALIDATOR = new SwiftResponseValidator();
    private static final ResponseValidator<CResponse> SWIFT_API_VALIDATOR = new SwiftApiResponseValidator(SWIFT_VALIDATOR);
    private static final String CONTENT_TYPE_DIRECTORY = "application/directory";
    private static final DateFormat DF_LAST_MODIFIED = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ENGLISH);
    private final String accountEndpoint;
    private final String authToken;
    private final RetryStrategy retryStrategy;
    private final boolean useDirectoryMarkers;
    private final HttpExecutor httpExecutor;
    private volatile Container currentContainer;

    Swift(String accountEndpoint, String authToken, RetryStrategy retryStrategy, boolean useDirectoryMarkers, HttpExecutor sessionManager) {
        this.accountEndpoint = accountEndpoint;
        this.authToken = authToken;
        this.retryStrategy = retryStrategy;
        this.useDirectoryMarkers = useDirectoryMarkers;
        this.httpExecutor = sessionManager;
    }

    private void configureSession(HttpRequestBase request, String format) {
        request.addHeader("X-Auth-token", this.authToken);
        if (format != null) {
            try {
                URI uri = request.getURI();
                if (uri.getRawQuery() != null) {
                    request.setURI(URI.create(uri + "&format=" + URLEncoder.encode(format, "UTF-8")));
                } else {
                    request.setURI(URI.create(uri + "?format=" + URLEncoder.encode(format, "UTF-8")));
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new UnsupportedOperationException("Error setting the request format", ex);
            }
        }
    }

    private RequestInvoker<CResponse> getBasicRequestInvoker(HttpRequestBase request, CPath path) {
        this.configureSession(request, null);
        return new RequestInvoker<CResponse>(new HttpRequestor((HttpUriRequest)request, path, this.httpExecutor), SWIFT_VALIDATOR);
    }

    private RequestInvoker<CResponse> getApiRequestInvoker(HttpRequestBase request, CPath path) {
        this.configureSession(request, "json");
        return new RequestInvoker<CResponse>(new HttpRequestor((HttpUriRequest)request, path, this.httpExecutor), SWIFT_API_VALIDATOR);
    }

    private Headers headOrNull(CPath path) {
        try {
            String url = this.getObjectUrl(path);
            HttpHead request = new HttpHead(url);
            RequestInvoker<CResponse> ri = this.getBasicRequestInvoker((HttpRequestBase)request, null);
            CResponse response = this.retryStrategy.invokeRetry(ri);
            return response.getHeaders();
        }
        catch (CFileNotFoundException ex) {
            return null;
        }
    }

    public Container useFirstContainer() throws CStorageException {
        List<Container> containers = this.getContainers();
        if (containers.isEmpty()) {
            throw new IllegalStateException("Account " + this.accountEndpoint + " has no container ?!");
        }
        this.useContainer(containers.get(0));
        if (containers.size() > 1) {
            LOGGER.warn("Account {} has {} containers: choosing first one as current: {}", new Object[]{this.accountEndpoint, containers.size(), this.currentContainer});
        }
        return this.currentContainer;
    }

    private void useContainer(Container container) {
        this.currentContainer = container;
        LOGGER.debug("Using container: {}", (Object)container);
    }

    private List<Container> getContainers() throws CStorageException {
        RequestInvoker<CResponse> ri = this.getApiRequestInvoker((HttpRequestBase)new HttpGet(this.accountEndpoint), null);
        JSONArray array = this.retryStrategy.invokeRetry(ri).asJSONArray();
        ArrayList<Container> containers = new ArrayList<Container>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            containers.add(new Container(array.getJSONObject(i)));
        }
        LOGGER.debug("Available containers: {}", (Object)containers.size());
        return containers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rawCreateFolder(CPath path) throws CStorageException {
        CResponse response = null;
        try {
            String url = this.getObjectUrl(path);
            HttpPut request = new HttpPut(url);
            request.addHeader("Content-Type", CONTENT_TYPE_DIRECTORY);
            RequestInvoker<CResponse> ri = this.getApiRequestInvoker((HttpRequestBase)request, path);
            response = this.retryStrategy.invokeRetry(ri);
        }
        catch (Throwable throwable) {
            PcsUtils.closeQuietly(response);
            throw throwable;
        }
        PcsUtils.closeQuietly(response);
    }

    private void createIntermediaryFoldersObjects(CPath leafFolderPath) throws CStorageException {
        CPath path = leafFolderPath;
        LinkedList<CPath> parentFolders = new LinkedList<CPath>();
        while (!path.isRoot()) {
            CFile file = this.getFile(path);
            if (file != null) {
                if (!file.isBlob()) break;
                throw new CInvalidFileTypeException(file.getPath(), false);
            }
            LOGGER.debug("Nothing exists at path: {}, will go up", (Object)path);
            parentFolders.add(0, path);
            path = path.getParent();
        }
        if (!parentFolders.isEmpty()) {
            LOGGER.debug("Inexisting parent_folders will be created: {}", parentFolders);
            for (CPath parent : parentFolders) {
                LOGGER.debug("Creating intermediary folder: {}", (Object)parent);
                this.rawCreateFolder(parent);
            }
        }
    }

    public CFile getFile(CPath path) {
        Headers headers = this.headOrNull(path);
        if (headers == null) {
            return null;
        }
        if (!headers.contains("Content-Type")) {
            LOGGER.warn("{} object has no content type ?!", (Object)path);
            return null;
        }
        CFile file = !CONTENT_TYPE_DIRECTORY.equals(headers.getHeaderValue("Content-Type")) ? new CBlob(path, Integer.parseInt(headers.getHeaderValue("Content-Length")), headers.getHeaderValue("Content-Type"), Swift.parseTimestamp(headers), this.parseMetaHeaders(headers)) : new CFolder(path, Swift.parseTimestamp(headers), this.parseMetaHeaders(headers));
        return file;
    }

    private JSONArray listObjectsWithinFolder(CPath path, String delimiter) throws CStorageException {
        String prefix = path.getPathName().substring(1) + "/";
        if (prefix.equals("/")) {
            prefix = "";
        }
        String url = this.getCurrentContainerUrl();
        URIBuilder builder = new URIBuilder(URI.create(url));
        builder.addParameter("prefix", prefix);
        if (delimiter != null) {
            builder.addParameter("delimiter", delimiter);
        }
        HttpGet request = new HttpGet(builder.build());
        RequestInvoker<CResponse> ri = this.getApiRequestInvoker((HttpRequestBase)request, path);
        return this.retryStrategy.invokeRetry(ri).asJSONArray();
    }

    public CFolderContent listFolder(CPath path) throws CStorageException {
        JSONArray array = this.listObjectsWithinFolder(path, "/");
        if (array == null || array.length() == 0) {
            CFile file = this.getFile(path);
            if (file == null) {
                return null;
            }
            if (file.isBlob()) {
                throw new CInvalidFileTypeException(path, false);
            }
            return new CFolderContent(Collections.EMPTY_MAP);
        }
        HashMap<CPath, CFile> ret = new HashMap<CPath, CFile>();
        for (int i = 0; i < array.length(); ++i) {
            boolean detailed;
            CFile file;
            JSONObject obj = array.getJSONObject(i);
            if (obj.has("subdir")) {
                file = new CFolder(new CPath(obj.getString("subdir")));
                detailed = false;
            } else {
                detailed = true;
                file = !CONTENT_TYPE_DIRECTORY.equals(obj.getString("content_type")) ? new CBlob(new CPath(obj.getString("name")), obj.getLong("bytes"), obj.getString("content_type"), Swift.parseLastModified(obj), null) : new CFolder(new CPath(obj.getString("name")), Swift.parseLastModified(obj), null);
            }
            if (!detailed && ret.containsKey(path)) continue;
            ret.put(file.getPath(), file);
        }
        return new CFolderContent(ret);
    }

    public CFolderContent listFolder(CFolder path) throws CStorageException {
        return this.listFolder(path.getPath());
    }

    public boolean createFolder(CPath path) throws CStorageException {
        CFile file = this.getFile(path);
        if (file != null) {
            if (file.isFolder()) {
                return false;
            }
            throw new CInvalidFileTypeException(path, false);
        }
        if (this.useDirectoryMarkers) {
            this.createIntermediaryFoldersObjects(path.getParent());
        }
        this.rawCreateFolder(path);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean delete(CPath path) throws CStorageException {
        JSONArray array = this.listObjectsWithinFolder(path, null);
        LOGGER.debug("List objects with folder {} = {}", (Object)path, (Object)array);
        ArrayList<String> pathnames = new ArrayList<String>(array.length() + 1);
        for (int i = 0; i < array.length(); ++i) {
            JSONObject obj = array.getJSONObject(i);
            pathnames.add("/" + obj.getString("name"));
        }
        Collections.sort(pathnames);
        Collections.reverse(pathnames);
        pathnames.add(path.getPathName());
        boolean atLeastOneDeleted = false;
        boolean lastDeleteWorked = false;
        for (String pathname : pathnames) {
            lastDeleteWorked = false;
            LOGGER.debug("deleting object at path : {}", (Object)pathname);
            String url = this.getObjectUrl(new CPath(pathname));
            CResponse response = null;
            try {
                RequestInvoker<CResponse> ri = this.getApiRequestInvoker((HttpRequestBase)new HttpDelete(url), path);
                response = this.retryStrategy.invokeRetry(ri);
                atLeastOneDeleted = true;
            }
            catch (CFileNotFoundException ex) {
                PcsUtils.closeQuietly(response);
                continue;
                catch (Throwable throwable) {
                    PcsUtils.closeQuietly(response);
                    throw throwable;
                }
            }
            PcsUtils.closeQuietly(response);
        }
        return atLeastOneDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(CDownloadRequest downloadRequest) throws CStorageException {
        String url = this.getObjectUrl(downloadRequest.getPath());
        HttpGet request = new HttpGet(url);
        for (Header header : downloadRequest.getHttpHeaders()) {
            request.addHeader(header);
        }
        RequestInvoker<CResponse> ri = this.getBasicRequestInvoker((HttpRequestBase)request, downloadRequest.getPath());
        CResponse response = null;
        try {
            response = this.retryStrategy.invokeRetry(ri);
            if (CONTENT_TYPE_DIRECTORY.equals(response.getContentType())) {
                throw new CInvalidFileTypeException(downloadRequest.getPath(), true);
            }
            PcsUtils.downloadDataToSink(response, downloadRequest.getByteSink());
        }
        catch (Throwable throwable) {
            PcsUtils.closeQuietly(response);
            throw throwable;
        }
        PcsUtils.closeQuietly(response);
    }

    private String getObjectUrl(CPath path) {
        String containerUrl = this.getCurrentContainerUrl();
        return containerUrl + path.getUrlEncoded();
    }

    private String getCurrentContainerUrl() {
        this.ensureCurrentContainerIsSet();
        return this.accountEndpoint + "/" + this.currentContainer;
    }

    private void ensureCurrentContainerIsSet() {
        if (this.currentContainer == null) {
            throw new IllegalStateException("Undefined current container for account " + this.accountEndpoint);
        }
    }

    public void upload(CUploadRequest uploadRequest) throws CStorageException {
        CFile file = this.getFile(uploadRequest.getPath());
        if (file != null && file.isFolder()) {
            throw new CInvalidFileTypeException(uploadRequest.getPath(), true);
        }
        if (this.useDirectoryMarkers) {
            this.createIntermediaryFoldersObjects(uploadRequest.getPath().getParent());
        }
        String url = this.getObjectUrl(uploadRequest.getPath());
        Headers headers = new Headers();
        if (uploadRequest.getContentType() != null) {
            headers.addHeader("Content-Type", uploadRequest.getContentType());
        }
        if (uploadRequest.getMetadata() != null) {
            this.addMetadataHeaders(headers, uploadRequest.getMetadata());
        }
        try {
            HttpPut request = new HttpPut(url);
            for (Header header : headers) {
                request.addHeader(header);
            }
            ByteSource bs = uploadRequest.getByteSource();
            request.setEntity((HttpEntity)new ByteSourceEntity(bs));
            RequestInvoker<CResponse> ri = this.getBasicRequestInvoker((HttpRequestBase)request, uploadRequest.getPath());
            this.retryStrategy.invokeRetry(ri).close();
        }
        catch (IOException ex) {
            throw new CStorageException("Can't close stream", ex);
        }
    }

    static Date parseLastModified(JSONObject json) {
        try {
            String lm = json.optString("last_modified", null);
            if (lm == null) {
                return null;
            }
            if (!lm.contains("+")) {
                lm = lm + "+0000";
            }
            StringBuilder builder = new StringBuilder(lm);
            builder.delete(lm.lastIndexOf(46) + 4, lm.lastIndexOf(43));
            return DF_LAST_MODIFIED.parse(builder.toString());
        }
        catch (ParseException ex) {
            LOGGER.warn("Error parsing date", (Throwable)ex);
            return null;
        }
    }

    static Date parseTimestamp(Headers headers) {
        String headerValue = headers.getHeaderValue("X-Timestamp");
        if (headerValue == null) {
            return null;
        }
        int index = headerValue.indexOf(46);
        long date = Long.parseLong(headerValue.substring(0, index)) * 1000L;
        return new Date(date += Long.parseLong(headerValue.substring(index + 1, index + 4)));
    }

    private CMetadata parseMetaHeaders(Headers headers) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (Header header : headers) {
            if (!header.getName().toLowerCase().startsWith("x-object-meta-")) continue;
            metadata.put(header.getName().substring(14).toLowerCase(), header.getValue());
        }
        return new CMetadata(metadata);
    }

    private void addMetadataHeaders(Headers headers, CMetadata metadata) {
        for (Map.Entry<String, String> item : metadata.getMap().entrySet()) {
            String value = item.getValue();
            value = value.replace("\r", "").replace("\n", "");
            headers.addHeader("X-Object-Meta-" + item.getKey(), value);
        }
    }

    public static class Container {
        private final String name;

        private Container(JSONObject json) {
            this.name = json.getString("name");
        }

        public String toString() {
            return this.name;
        }
    }

    private static class SwiftApiResponseValidator
    implements ResponseValidator<CResponse> {
        private final ResponseValidator<CResponse> parent;

        private SwiftApiResponseValidator(ResponseValidator<CResponse> parent) {
            this.parent = parent;
        }

        @Override
        public void validateResponse(CResponse response, CPath path) throws CStorageException {
            this.parent.validateResponse(response, path);
            long cl = response.getContentLength();
            if (cl > 0L) {
                PcsUtils.ensureContentTypeIsJson(response, false);
            }
        }
    }

    private static class SwiftResponseValidator
    implements ResponseValidator<CResponse> {
        private SwiftResponseValidator() {
        }

        @Override
        public void validateResponse(CResponse response, CPath path) throws CStorageException {
            LOGGER.debug("validating swift response: {} {} : {} {}", new Object[]{response.getMethod(), PcsUtils.shortenUrl(response.getUri()), response.getStatus(), response.getReason()});
            int code = response.getStatus();
            if (code < 300) {
                return;
            }
            if (code >= 500 || code == 498 || code == 429) {
                throw new CRetriableException(this.buildHttpError(response, null, path));
            }
            throw this.buildHttpError(response, null, path);
        }

        private CStorageException buildHttpError(CResponse response, String errorMessage, CPath path) {
            return PcsUtils.buildCStorageException(response, errorMessage, path);
        }
    }
}

