/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.netheos.pcsapi.bytesio.ByteSource;
import net.netheos.pcsapi.utils.PcsUtils;
import org.apache.http.entity.mime.content.AbstractContentBody;

public class ByteSourceBody
extends AbstractContentBody {
    private final ByteSource byteSource;
    private InputStream currentStream;
    private final String filename;

    public ByteSourceBody(ByteSource bs, String filename, String contentType) {
        super(contentType != null ? contentType : "application/octet-stream");
        this.byteSource = bs;
        this.filename = filename;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        if (this.currentStream != null) {
            PcsUtils.closeQuietly(this.currentStream);
        }
        this.currentStream = this.byteSource.openStream();
        return this.currentStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        InputStream instream = this.getContent();
        try {
            int n;
            byte[] buffer = new byte[4096];
            while ((n = instream.read(buffer)) != -1) {
                outstream.write(buffer, 0, n);
            }
        }
        finally {
            PcsUtils.closeQuietly(instream);
            this.consumeContent();
        }
    }

    public void consumeContent() throws IOException {
        if (this.currentStream != null) {
            PcsUtils.closeQuietly(this.currentStream);
            this.currentStream = null;
        }
    }

    public String getCharset() {
        return null;
    }

    public String getTransferEncoding() {
        return "binary";
    }

    public String getFilename() {
        return this.filename;
    }

    public long getContentLength() {
        return this.byteSource.length();
    }
}

