/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.netheos.pcsapi.bytesio.ByteSource;
import net.netheos.pcsapi.utils.PcsUtils;
import org.apache.http.entity.AbstractHttpEntity;

public class ByteSourceEntity
extends AbstractHttpEntity {
    private final ByteSource byteSource;
    private InputStream currentStream;

    public ByteSourceEntity(ByteSource bs) {
        this.byteSource = bs;
        this.setContentType(null);
        this.setContentEncoding(null);
        this.setChunked(false);
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.byteSource.length();
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        if (this.currentStream != null) {
            PcsUtils.closeQuietly(this.currentStream);
        }
        this.currentStream = this.byteSource.openStream();
        return this.currentStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        InputStream instream = this.getContent();
        try {
            int n;
            byte[] buffer = new byte[4096];
            while ((n = instream.read(buffer)) != -1) {
                outstream.write(buffer, 0, n);
            }
        }
        finally {
            PcsUtils.closeQuietly(instream);
            this.consumeContent();
        }
    }

    public boolean isStreaming() {
        return false;
    }

    public void consumeContent() throws IOException {
        if (this.currentStream != null) {
            PcsUtils.closeQuietly(this.currentStream);
            this.currentStream = null;
        }
    }
}

