/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.request;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import net.netheos.pcsapi.exceptions.CStorageException;
import net.netheos.pcsapi.request.Headers;
import net.netheos.pcsapi.utils.PcsUtils;
import net.netheos.pcsapi.utils.XmlUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;

public class CResponse
implements Closeable {
    private final int status;
    private final HttpEntity entity;
    private final String method;
    private final URI uri;
    private final String contentType;
    private final String reason;
    private final Headers headers;

    public CResponse(HttpUriRequest request, HttpResponse response) {
        this.method = request.getMethod();
        this.uri = request.getURI();
        this.status = response.getStatusLine().getStatusCode();
        this.entity = response.getEntity();
        String tmp = null;
        if (this.entity != null && this.entity.getContentType() != null) {
            tmp = this.entity.getContentType().getValue();
        }
        this.contentType = tmp;
        tmp = response.getStatusLine().getReasonPhrase();
        if (tmp == null || tmp.isEmpty()) {
            tmp = "No reason specified";
        }
        this.reason = tmp;
        this.headers = new Headers(response.getAllHeaders());
    }

    public int getStatus() {
        return this.status;
    }

    public String getMethod() {
        return this.method;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getReason() {
        return this.reason;
    }

    @Override
    public void close() throws IOException {
        if (this.entity != null) {
            this.entity.getContent().close();
        }
    }

    public String asString() {
        try {
            return EntityUtils.toString((HttpEntity)this.entity, (String)PcsUtils.UTF8.name());
        }
        catch (IOException e) {
            throw new CStorageException("Can't get string from HTTP entity", e);
        }
    }

    public JSONObject asJSONObject() {
        if (this.entity == null) {
            return null;
        }
        String str = this.asString();
        try {
            return new JSONObject(str);
        }
        catch (JSONException ex) {
            throw new CStorageException("Error parsing the JSON response: " + str, ex);
        }
    }

    public Document asDom() {
        if (this.entity == null) {
            return null;
        }
        return XmlUtils.getDomFromString(this.asString());
    }

    public JSONArray asJSONArray() {
        if (this.entity == null) {
            return null;
        }
        String str = this.asString();
        try {
            return new JSONArray(str);
        }
        catch (JSONException ex) {
            throw new CStorageException("Error parsing the JSON response: " + str, ex);
        }
    }

    public long getContentLength() {
        if (this.entity == null) {
            return 0L;
        }
        return this.entity.getContentLength();
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public InputStream openStream() {
        if (this.entity == null) {
            return null;
        }
        try {
            return this.entity.getContent();
        }
        catch (IOException ex) {
            throw new CStorageException("Can't open stream", ex);
        }
    }
}

