/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.request;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class Headers
implements Iterable<Header> {
    private final List<Header> headers = new ArrayList<Header>();

    Headers(Header[] headers) {
        this.headers.addAll(Arrays.asList(headers));
    }

    public Headers() {
    }

    public void addHeader(String name, String value) {
        this.headers.add((Header)new BasicHeader(name, value));
    }

    public void addHeader(Header header) {
        this.headers.add(header);
    }

    public void removeHeader(String name) {
        ListIterator<Header> it = this.headers.listIterator();
        while (it.hasNext()) {
            if (!it.next().getName().equals(name)) continue;
            it.remove();
        }
    }

    public boolean contains(String name) {
        for (Header header : this.headers) {
            if (!header.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public String getHeaderValue(String name) {
        for (Header header : this.headers) {
            if (!header.getName().equals(name)) continue;
            return header.getValue();
        }
        return null;
    }

    @Override
    public Iterator<Header> iterator() {
        return this.headers.iterator();
    }

    public String toString() {
        return this.headers.toString();
    }
}

