/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.request;

import java.io.IOException;
import java.io.OutputStream;
import net.netheos.pcsapi.utils.PcsUtils;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONBody
extends AbstractContentBody {
    private static final String CONTENT_TYPE = "application/json";
    private final byte[] content;
    private final String filename;

    public JSONBody(JSONObject json, String filename) {
        super(CONTENT_TYPE);
        this.content = json.toString().getBytes(PcsUtils.UTF8);
        this.filename = filename;
    }

    public JSONBody(JSONArray json, String filename) {
        super(CONTENT_TYPE);
        this.content = json.toString().getBytes(PcsUtils.UTF8);
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.content);
        out.flush();
    }

    public String getCharset() {
        return PcsUtils.UTF8.name();
    }

    public String getTransferEncoding() {
        return "8bit";
    }

    public long getContentLength() {
        return this.content.length;
    }
}

