/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.request;

import java.io.Closeable;
import java.util.concurrent.Callable;
import net.netheos.pcsapi.exceptions.CStorageException;
import net.netheos.pcsapi.request.Requestor;
import net.netheos.pcsapi.request.ResponseValidator;
import net.netheos.pcsapi.utils.PcsUtils;

public class RequestInvoker<T>
implements Callable<T> {
    protected final Requestor<T> requestor;
    protected final ResponseValidator<T> validator;

    public RequestInvoker(Requestor<T> requestor, ResponseValidator<T> validator) {
        this.requestor = requestor;
        this.validator = validator;
    }

    @Override
    public T call() throws Exception {
        Object response = this.requestor.call();
        try {
            this.validateResponse(response);
            return (T)response;
        }
        catch (RuntimeException ex) {
            if (response instanceof Closeable) {
                PcsUtils.closeQuietly((Closeable)response);
            }
            throw ex;
        }
    }

    protected void validateResponse(T response) throws CStorageException {
        this.validator.validateResponse(response, this.requestor.getPath());
    }
}

