/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.storage;

import android.net.http.AndroidHttpClient;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.netheos.pcsapi.credentials.AppInfo;
import net.netheos.pcsapi.credentials.AppInfoRepository;
import net.netheos.pcsapi.credentials.UserCredentials;
import net.netheos.pcsapi.credentials.UserCredentialsRepository;
import net.netheos.pcsapi.models.RetryStrategy;
import net.netheos.pcsapi.storage.IStorageProvider;
import net.netheos.pcsapi.storage.StorageProvider;
import net.netheos.pcsapi.utils.PcsUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class StorageBuilder {
    private final String providerName;
    private final Class<?> providerClass;
    private AppInfoRepository appInfoRepo;
    private String appName;
    private UserCredentialsRepository userCredentialsRepo;
    private String userId;
    private boolean forBootstrapping;
    private RetryStrategy retryStrategy;
    private HttpClient httpClient = StorageBuilder.createDefaultClient();

    StorageBuilder(String providerName, Class<?> providerClass) {
        this.providerName = providerName;
        this.providerClass = providerClass;
        this.forBootstrapping = false;
        this.retryStrategy = new RetryStrategy(5, 1000L);
    }

    public StorageBuilder setAppInfoRepository(AppInfoRepository appInfoRepo, String appName) {
        this.appInfoRepo = appInfoRepo;
        this.appName = appName;
        return this;
    }

    public StorageBuilder setUserCredentialsRepository(UserCredentialsRepository userCredentialsRepo, String userId) {
        this.userCredentialsRepo = userCredentialsRepo;
        this.userId = userId;
        return this;
    }

    public StorageBuilder setForBootstrapping(boolean forBootstrapping) {
        this.forBootstrapping = forBootstrapping;
        return this;
    }

    public IStorageProvider build() {
        if (this.appInfoRepo == null) {
            throw new IllegalStateException("Undefined application information repository");
        }
        if (this.userCredentialsRepo == null) {
            throw new IllegalStateException("Undefined user credentials repository");
        }
        try {
            Constructor<?> providerConstructor = this.providerClass.getConstructor(StorageBuilder.class);
            StorageProvider providerInstance = (StorageProvider)providerConstructor.newInstance(this);
            return providerInstance;
        }
        catch (InvocationTargetException itex) {
            Throwable cause = itex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new UnsupportedOperationException("Error instantiating the provider " + this.providerClass.getSimpleName(), itex);
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("Error instantiating the provider " + this.providerClass.getSimpleName(), ex);
        }
    }

    public AppInfo getAppInfo() {
        return this.appInfoRepo.get(this.providerName, this.appName);
    }

    public UserCredentialsRepository getUserCredentialsRepo() {
        return this.userCredentialsRepo;
    }

    public UserCredentials<?> getUserCredentials() {
        if (!this.forBootstrapping) {
            return this.userCredentialsRepo.get(this.getAppInfo(), this.userId);
        }
        return null;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public StorageBuilder setHttpClient(HttpClient httpClient) {
        PcsUtils.releaseHttpClient(this.httpClient);
        this.httpClient = httpClient;
        return this;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public StorageBuilder setRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
        return this;
    }

    private static HttpClient createDefaultClient() {
        if (PcsUtils.ANDROID) {
            return AndroidHttpClient.newInstance((String)"pcs-api");
        }
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)15000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)60000);
        return new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager(), (HttpParams)params);
    }
}

