/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.storage;

import net.netheos.pcsapi.exceptions.CStorageException;
import net.netheos.pcsapi.models.RetryStrategy;
import net.netheos.pcsapi.oauth.SessionManager;
import net.netheos.pcsapi.storage.IStorageProvider;
import net.netheos.pcsapi.utils.PcsUtils;
import org.apache.http.client.HttpClient;

public abstract class StorageProvider<T extends SessionManager>
implements IStorageProvider {
    protected final RetryStrategy retryStrategy;
    protected final T sessionManager;
    private final String providerName;
    private final HttpClient httpClient;

    protected StorageProvider(String providerName, T sessionManager, RetryStrategy retryStrategy, HttpClient httpClient) {
        this.providerName = providerName;
        this.sessionManager = sessionManager;
        this.retryStrategy = retryStrategy;
        this.httpClient = httpClient;
    }

    public T getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public void close() throws CStorageException {
        PcsUtils.releaseHttpClient(this.httpClient);
    }

    public String toString() {
        return this.getProviderName();
    }
}

