/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.utils;

import android.net.http.AndroidHttpClient;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import net.netheos.pcsapi.bytesio.ByteSink;
import net.netheos.pcsapi.bytesio.ByteSinkStream;
import net.netheos.pcsapi.exceptions.CAuthenticationException;
import net.netheos.pcsapi.exceptions.CFileNotFoundException;
import net.netheos.pcsapi.exceptions.CHttpException;
import net.netheos.pcsapi.exceptions.CRetriableException;
import net.netheos.pcsapi.exceptions.CStorageException;
import net.netheos.pcsapi.models.CPath;
import net.netheos.pcsapi.request.CResponse;
import org.apache.http.client.HttpClient;

public final class PcsUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final char[] CHARS = "abcdefghjkmnpqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ23456789".toCharArray();
    public static final boolean ANDROID = System.getProperty("java.vm.name").toLowerCase().contains("dalvik");

    private PcsUtils() {
    }

    public static void ensureContentTypeIsJson(CResponse response, boolean isRetriable) throws CStorageException {
        String contentType = response.getContentType();
        CStorageException ex = null;
        if (contentType == null) {
            ex = PcsUtils.buildCStorageException(response, "Undefined Content-Type in server response", null);
        } else if (!contentType.contains("application/json") && !contentType.contains("text/javascript")) {
            ex = PcsUtils.buildCStorageException(response, "Content-Type is not json: " + contentType, null);
        }
        if (ex != null) {
            if (isRetriable) {
                ex = new CRetriableException(ex);
            }
            throw ex;
        }
    }

    public static void ensureContentTypeIsXml(CResponse response, boolean isRetriable) throws CStorageException {
        String contentType = response.getContentType();
        CStorageException ex = null;
        if (contentType == null) {
            ex = PcsUtils.buildCStorageException(response, "Undefined Content-Type in server response", null);
        } else if (!contentType.contains("application/xml") && !contentType.contains("text/xml")) {
            ex = PcsUtils.buildCStorageException(response, "Content-Type is not xml: " + contentType, null);
        }
        if (ex != null) {
            if (isRetriable) {
                ex = new CRetriableException(ex);
            }
            throw ex;
        }
    }

    public static CStorageException buildCStorageException(CResponse response, String message, CPath path) {
        switch (response.getStatus()) {
            case 401: {
                return new CAuthenticationException(message, response);
            }
            case 404: {
                message = "No file found at URL " + PcsUtils.shortenUrl(response.getUri()) + " (" + message + ")";
                return new CFileNotFoundException(message, path);
            }
        }
        return new CHttpException(message, response);
    }

    public static String shortenUrl(URI uri) {
        return uri.getScheme() + "://" + uri.getHost() + uri.getPath();
    }

    public static String abbreviate(String source, int maxLen) {
        if (source == null || source.length() <= maxLen) {
            return source;
        }
        return source.substring(0, maxLen) + "...";
    }

    public static void downloadDataToSink(CResponse response, ByteSink byteSink) {
        InputStream is = null;
        ByteSinkStream bss = null;
        boolean success = false;
        try {
            int len;
            long contentLength = response.getContentLength();
            if (contentLength >= 0L) {
                byteSink.setExpectedLength(contentLength);
            }
            long current = 0L;
            is = response.openStream();
            bss = byteSink.openStream();
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) != -1) {
                current += (long)len;
                bss.write(buffer, 0, len);
            }
            if (contentLength < 0L) {
                byteSink.setExpectedLength(current);
            }
            bss.flush();
            bss.close();
            bss = null;
            success = true;
            if (bss != null && !success) {
                bss.abort();
            }
        }
        catch (IOException ex) {
            try {
                throw new CStorageException(ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                if (bss != null && !success) {
                    bss.abort();
                }
                PcsUtils.closeQuietly(is);
                PcsUtils.closeQuietly(bss);
                throw throwable;
            }
        }
        PcsUtils.closeQuietly(is);
        PcsUtils.closeQuietly(bss);
    }

    public static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String randomString(int len) {
        return PcsUtils.randomString(CHARS, len);
    }

    public static String randomString(char[] values, int len) {
        SecureRandom rnd = new SecureRandom();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(values[rnd.nextInt(values.length)]);
        }
        return sb.toString();
    }

    public static void releaseHttpClient(HttpClient httpClient) {
        if (ANDROID && httpClient instanceof AndroidHttpClient) {
            ((AndroidHttpClient)httpClient).close();
        }
        httpClient.getConnectionManager().shutdown();
    }
}

