/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.utils;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import net.netheos.pcsapi.utils.PcsUtils;
import net.netheos.pcsapi.utils.URIUtil;

public class URIBuilder {
    private static final String SEPARATOR = "/";
    private final URI baseURI;
    private final StringBuilder path = new StringBuilder();
    private final Map<String, String> queryParams;

    public URIBuilder(URI baseURI) {
        try {
            this.baseURI = new URI(baseURI.getScheme(), baseURI.getAuthority(), null, null, null);
            this.encodedPath(baseURI.getRawPath());
            this.queryParams = URIUtil.parseQueryParameters(baseURI.getRawQuery());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final URIBuilder encodedPath(String encodedPath) {
        if (this.path.length() > 0) {
            if (this.path.charAt(this.path.length() - 1) != '/' && !encodedPath.startsWith(SEPARATOR)) {
                this.path.append(SEPARATOR);
            } else if (this.path.charAt(this.path.length() - 1) == '/' && encodedPath.charAt(0) == '/') {
                this.path.deleteCharAt(this.path.length() - 1);
            }
        }
        this.path.append(encodedPath);
        return this;
    }

    public URIBuilder queryParameters(Map<String, String> queryParams) {
        this.queryParams.clear();
        this.queryParams.putAll(queryParams);
        return this;
    }

    public URIBuilder addNullParameter(String key) {
        if (key != null) {
            this.queryParams.put(key, null);
        }
        return this;
    }

    public URIBuilder addParameter(String key, String value) {
        if (key != null && value != null) {
            this.queryParams.put(key, value);
        }
        return this;
    }

    public String toString() {
        return this.build().toString();
    }

    public URI build() {
        StringBuilder builder = new StringBuilder(this.baseURI.toString());
        builder.append(this.path.toString());
        if (this.queryParams != null && !this.queryParams.isEmpty()) {
            builder.append(this.queryParameters());
        }
        return URI.create(builder.toString());
    }

    private CharSequence queryParameters() {
        StringBuilder builder = new StringBuilder("?");
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(this.queryParams.entrySet());
        for (int i = 0; i < entries.size(); ++i) {
            builder.append(this.urlEncode((String)((Map.Entry)entries.get(i)).getKey()));
            String value = (String)((Map.Entry)entries.get(i)).getValue();
            if (value != null) {
                builder.append("=").append(this.urlEncode(value));
            }
            if (i >= entries.size() - 1) continue;
            builder.append("&");
        }
        return builder;
    }

    private String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, PcsUtils.UTF8.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnsupportedOperationException("Error generating query parameters", ex);
        }
    }
}

