/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.utils;

import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.netheos.pcsapi.exceptions.CStorageException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XmlUtils {
    private static final Map<Integer, String> SPECIAL_CHARS_NAMES_ARRAY;
    private static final Map<String, Integer> SPECIAL_CHARS_VALUES_ARRAY;

    public static String escape(String str) {
        StringBuffer buf = new StringBuffer(str.length() * 2);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            String entityName = SPECIAL_CHARS_NAMES_ARRAY.get(ch);
            if (entityName == null) {
                if (ch > '\u007f') {
                    char intValue = ch;
                    buf.append("&#");
                    buf.append((int)intValue);
                    buf.append(';');
                    continue;
                }
                buf.append(ch);
                continue;
            }
            buf.append('&');
            buf.append(entityName);
            buf.append(';');
        }
        return buf.toString();
    }

    public String unescape(String str) {
        StringBuffer buf = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '&') {
                int entityValue;
                String entityName;
                int semi;
                block14: {
                    semi = str.indexOf(59, i + 1);
                    if (semi == -1) {
                        buf.append(ch);
                        continue;
                    }
                    entityName = str.substring(i + 1, semi);
                    if (entityName.length() == 0) {
                        entityValue = -1;
                    } else if (entityName.charAt(0) == '#') {
                        if (entityName.length() == 1) {
                            entityValue = -1;
                        } else {
                            char charAt1 = entityName.charAt(1);
                            try {
                                if (charAt1 == 'x' || charAt1 == 'X') {
                                    entityValue = Integer.valueOf(entityName.substring(2), 16);
                                    break block14;
                                }
                                entityValue = Integer.parseInt(entityName.substring(1));
                            }
                            catch (NumberFormatException ex) {
                                entityValue = -1;
                            }
                        }
                    } else {
                        entityValue = SPECIAL_CHARS_VALUES_ARRAY.get(entityName);
                    }
                }
                if (entityValue == -1) {
                    buf.append('&');
                    buf.append(entityName);
                    buf.append(';');
                } else {
                    buf.append((char)entityValue);
                }
                i = semi;
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static Document getDomFromString(String str) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(str)));
        }
        catch (Exception e) {
            throw new CStorageException("Error parsing the Xml response: " + str, e);
        }
    }

    static {
        HashMap<Integer, String> namesMap = new HashMap<Integer, String>(5);
        namesMap.put(34, "quot");
        namesMap.put(38, "amp");
        namesMap.put(39, "apos");
        namesMap.put(60, "lt");
        namesMap.put(62, "gt");
        SPECIAL_CHARS_NAMES_ARRAY = Collections.unmodifiableMap(namesMap);
        HashMap<String, Integer> valuesMap = new HashMap<String, Integer>(5);
        valuesMap.put("quot", 34);
        valuesMap.put("amp", 38);
        valuesMap.put("apos", 39);
        valuesMap.put("lt", 60);
        valuesMap.put("gt", 62);
        SPECIAL_CHARS_VALUES_ARRAY = Collections.unmodifiableMap(valuesMap);
    }
}

