/*
 * Copyright (c) Badbird5907 2022.
 * MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

package net.octopvp.commander.command;

import lombok.Getter;
import lombok.Setter;
import net.octopvp.commander.argument.CommandArgs;
import net.octopvp.commander.sender.CoreCommandSender;

import java.util.Deque;

@Getter
@Setter
public class CommandContext {
    private CommandInfo commandInfo;
    private String label;
    private String[] originalArgs;
    private CoreCommandSender commandSender;
    private String permission;
    private CommandArgs args;

    public CommandContext(CommandInfo commandInfo, String label, String[] originalArgs, CoreCommandSender commandSender, CommandArgs commandArgs) {
        this.commandInfo = commandInfo;
        this.label = label;
        this.originalArgs = originalArgs;
        this.commandSender = commandSender;
        this.permission = commandInfo.getPermission();
        this.args = commandArgs;
    }
}
