package net.orbyfied.j8.command.exception;

import net.md_5.bungee.api.ChatColor;
import net.orbyfied.j8.command.ErrorLocation;
import net.orbyfied.j8.command.Node;

public class CommandParseException extends CommandException {

    protected ErrorLocation location;

    public CommandParseException(Node rootCommand, ErrorLocation loc, String message) {
        super(rootCommand, message);
        this.location = loc;
    }

    public CommandParseException(Node rootCommand, ErrorLocation loc, Exception e) {
        super(rootCommand, e);
        this.location = loc;
    }

    public CommandParseException(Node rootCommand, ErrorLocation loc, String msg, Exception e) {
        super(rootCommand, msg, e);
        this.location = loc;
    }

    @Override
    public boolean isSevere() {
        return false;
    }

    public ErrorLocation getLocation() {
        return location;
    }

    @Override
    public String getErrorName() {
        return "Command Parsing";
    }

    @Override
    public String getFormattedString() {
        return super.getFormattedPrefix() + ChatColor.WHITE + " at " + getLocationString(location) + getFormattedSuffix();
    }

    public static String getLocationString(ErrorLocation loc) {
        // create builder
        StringBuilder b = new StringBuilder();

        // append prefix
        b.append(ChatColor.GREEN).append("...");

        // append index
        b.append(ChatColor.GRAY).append("[").append(loc.getStartIndex()).append(":").append(loc.getEndIndex()).append("]")
                .append(" ");

        // append substrings
        String str = loc.getReader().getString();

        // figure out locations
        final int prevLen = 6;

        int maxIdx = str.length() - 1;
        int startIndex0 = Math.max(Math.min(loc.getStartIndex(), maxIdx), 0);
        int endIndex0   = Math.max(Math.min(loc.getEndIndex(), maxIdx), 0);
        int startIndex  = Math.min(startIndex0, endIndex0);
        int endIndex    = Math.max(startIndex0, endIndex0);

        int pStartIndex = Math.max(Math.min(startIndex - prevLen, maxIdx), 0);
        int pEndIndex   = Math.max(Math.min(endIndex   + prevLen, maxIdx), 0);

        // get all string parts
        String subPrefix = str.substring(pStartIndex, startIndex);
        String sub       = str.substring(startIndex,  endIndex);
        String subSuffix = str.substring(endIndex,    pEndIndex);

        // append all parts formatted
        b.append(ChatColor.GREEN).append(subPrefix);
        b.append(ChatColor.RED).append(ChatColor.UNDERLINE).append(sub);
        b.append(ChatColor.GREEN).append(subSuffix);

        // append suffix
        b.append(ChatColor.GREEN).append("...");

        // return
        return b.toString();
    }

}
