/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.spring.boot.autoconfigure;

import com.gitee.easyopen.limit.LimitType;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="easyopen")
public class EasyopenProperties {
    public static final String EASYOPEN_PREFIX = "easyopen";
    private static final String DEFAULT_APP_NAME = "app";
    private static String CONFIG_FOLDER = System.getProperty("user.dir") + File.separator + "local-config" + File.separator;
    private Map<String, String> appSecret = Collections.emptyMap();
    private List<String> interceptors = Collections.emptyList();
    private List<String> isvModules = Collections.emptyList();
    private String appName;
    private String defaultVersion = "";
    private int timeoutSeconds = 3;
    private boolean showDoc;
    private String docPassword;
    private String docClassPath = "/easyopen_template/doc.html";
    private String docPdfClassPath = "/easyopen_template/docPdf.html";
    private String docPdfCssClassPath = "/easyopen_template/docPdf.css";
    private String monitorClassPath = "/easyopen_template/monitor.html";
    private String loginClassPath = "/easyopen_template/login.html";
    private String limitClassPath = "/easyopen_template/limit.html";
    private String limitPassword = "limit123";
    private LimitType defaultLimitType = LimitType.LIMIT;
    private int defaultLimitCount = 50;
    private int defaultTokenBucketCount = 50;
    private String localLimitConfigFile;
    private String localPermissionConfigFile;
    private String localSecretConfigFile;
    private boolean ignoreValidate;
    private String oauth2LoginUri = "/oauth2login";
    private long oauth2ExpireIn = 7200L;
    private int jwtExpireIn = 7200;
    private String privateKey;
    private String priKeyPath = "/pri.key";
    private boolean showMonitor = true;
    private String monitorPassword = "monitor123";
    private int monitorErrorQueueSize = 5;
    private int monitorExecutorSize = 2;
    private String configServerIp;
    private String configServerPort;
    private String docUrl;
    private boolean configDistributedLimit;
    private String markdownDocDir;

    public EasyopenProperties() {
        this.setAppName(DEFAULT_APP_NAME);
    }

    public List<String> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<String> interceptors) {
        this.interceptors = interceptors;
    }

    public List<String> getIsvModules() {
        return this.isvModules;
    }

    public void setIsvModules(List<String> isvModules) {
        this.isvModules = isvModules;
    }

    public String getConfigServerIp() {
        return this.configServerIp;
    }

    public void setConfigServerIp(String configServerIp) {
        this.configServerIp = configServerIp;
    }

    public String getConfigServerPort() {
        return this.configServerPort;
    }

    public void setConfigServerPort(String configServerPort) {
        this.configServerPort = configServerPort;
    }

    public boolean isConfigDistributedLimit() {
        return this.configDistributedLimit;
    }

    public void setConfigDistributedLimit(boolean configDistributedLimit) {
        this.configDistributedLimit = configDistributedLimit;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
        this.localLimitConfigFile = System.getProperty("conflimit.file", CONFIG_FOLDER + appName + "-limit.json");
        this.localPermissionConfigFile = System.getProperty("confperm.file", CONFIG_FOLDER + appName + "-permission.json");
        this.localSecretConfigFile = System.getProperty("confsecret.file", CONFIG_FOLDER + appName + "-secret.json");
    }

    public Map<String, String> getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(Map<String, String> appSecret) {
        this.appSecret = appSecret;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public boolean isShowDoc() {
        return this.showDoc;
    }

    public void setShowDoc(boolean showDoc) {
        this.showDoc = showDoc;
    }

    public String getDocPassword() {
        return this.docPassword;
    }

    public void setDocPassword(String docPassword) {
        this.docPassword = docPassword;
    }

    public String getDocClassPath() {
        return this.docClassPath;
    }

    public void setDocClassPath(String docClassPath) {
        this.docClassPath = docClassPath;
    }

    public String getDocPdfClassPath() {
        return this.docPdfClassPath;
    }

    public void setDocPdfClassPath(String docPdfClassPath) {
        this.docPdfClassPath = docPdfClassPath;
    }

    public String getDocPdfCssClassPath() {
        return this.docPdfCssClassPath;
    }

    public void setDocPdfCssClassPath(String docPdfCssClassPath) {
        this.docPdfCssClassPath = docPdfCssClassPath;
    }

    public String getMonitorClassPath() {
        return this.monitorClassPath;
    }

    public void setMonitorClassPath(String monitorClassPath) {
        this.monitorClassPath = monitorClassPath;
    }

    public String getLoginClassPath() {
        return this.loginClassPath;
    }

    public void setLoginClassPath(String loginClassPath) {
        this.loginClassPath = loginClassPath;
    }

    public String getLimitClassPath() {
        return this.limitClassPath;
    }

    public void setLimitClassPath(String limitClassPath) {
        this.limitClassPath = limitClassPath;
    }

    public String getLimitPassword() {
        return this.limitPassword;
    }

    public void setLimitPassword(String limitPassword) {
        this.limitPassword = limitPassword;
    }

    public LimitType getDefaultLimitType() {
        return this.defaultLimitType;
    }

    public void setDefaultLimitType(LimitType defaultLimitType) {
        this.defaultLimitType = defaultLimitType;
    }

    public int getDefaultLimitCount() {
        return this.defaultLimitCount;
    }

    public void setDefaultLimitCount(int defaultLimitCount) {
        this.defaultLimitCount = defaultLimitCount;
    }

    public int getDefaultTokenBucketCount() {
        return this.defaultTokenBucketCount;
    }

    public void setDefaultTokenBucketCount(int defaultTokenBucketCount) {
        this.defaultTokenBucketCount = defaultTokenBucketCount;
    }

    public String getLocalLimitConfigFile() {
        return this.localLimitConfigFile;
    }

    public void setLocalLimitConfigFile(String localLimitConfigFile) {
        this.localLimitConfigFile = localLimitConfigFile;
    }

    public String getLocalPermissionConfigFile() {
        return this.localPermissionConfigFile;
    }

    public void setLocalPermissionConfigFile(String localPermissionConfigFile) {
        this.localPermissionConfigFile = localPermissionConfigFile;
    }

    public String getLocalSecretConfigFile() {
        return this.localSecretConfigFile;
    }

    public void setLocalSecretConfigFile(String localSecretConfigFile) {
        this.localSecretConfigFile = localSecretConfigFile;
    }

    public boolean isIgnoreValidate() {
        return this.ignoreValidate;
    }

    public void setIgnoreValidate(boolean ignoreValidate) {
        this.ignoreValidate = ignoreValidate;
    }

    public String getOauth2LoginUri() {
        return this.oauth2LoginUri;
    }

    public void setOauth2LoginUri(String oauth2LoginUri) {
        this.oauth2LoginUri = oauth2LoginUri;
    }

    public long getOauth2ExpireIn() {
        return this.oauth2ExpireIn;
    }

    public void setOauth2ExpireIn(long oauth2ExpireIn) {
        this.oauth2ExpireIn = oauth2ExpireIn;
    }

    public int getJwtExpireIn() {
        return this.jwtExpireIn;
    }

    public void setJwtExpireIn(int jwtExpireIn) {
        this.jwtExpireIn = jwtExpireIn;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPriKeyPath() {
        return this.priKeyPath;
    }

    public void setPriKeyPath(String priKeyPath) {
        this.priKeyPath = priKeyPath;
    }

    public boolean isShowMonitor() {
        return this.showMonitor;
    }

    public void setShowMonitor(boolean showMonitor) {
        this.showMonitor = showMonitor;
    }

    public String getMonitorPassword() {
        return this.monitorPassword;
    }

    public void setMonitorPassword(String monitorPassword) {
        this.monitorPassword = monitorPassword;
    }

    public int getMonitorErrorQueueSize() {
        return this.monitorErrorQueueSize;
    }

    public void setMonitorErrorQueueSize(int monitorErrorQueueSize) {
        this.monitorErrorQueueSize = monitorErrorQueueSize;
    }

    public int getMonitorExecutorSize() {
        return this.monitorExecutorSize;
    }

    public void setMonitorExecutorSize(int monitorExecutorSize) {
        this.monitorExecutorSize = monitorExecutorSize;
    }

    public String getDocUrl() {
        return this.docUrl;
    }

    public void setDocUrl(String docUrl) {
        this.docUrl = docUrl;
    }

    public String getMarkdownDocDir() {
        return this.markdownDocDir;
    }

    public void setMarkdownDocDir(String markdownDocDir) {
        this.markdownDocDir = markdownDocDir;
    }
}

