package com.gitee.fastmybatis.core.ext.spi.impl;

import com.gitee.fastmybatis.core.ext.MapperRunner;
import com.gitee.fastmybatis.core.ext.spi.MapperBuilder;
import org.springframework.context.ApplicationContext;

/**
 * @author thc
 */
public class SpringContextMapperBuilder implements MapperBuilder {

    @Override
    public <T> MapperRunner<T> getMapperRunner(Class<T> mapperClass, Object applicationContext) {
        ApplicationContext ctx = (ApplicationContext) applicationContext;
        T mapper = ctx.getBean(mapperClass);
        return new MapperRunner<>(mapper, null);
    }
}
