/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.hibernate3;

import java.util.HashMap;
import java.util.Map;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheObject;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.GeneralDataRegion;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.Timestamper;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cache.TransactionalDataRegion;
import org.hibernate.cache.access.AccessType;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.access.EntityRegionAccessStrategy;

public class J2CacheRegion
implements GeneralDataRegion {
    private String regionName;
    private CacheChannel cache;

    public J2CacheRegion(String name, CacheChannel cache) {
        this.regionName = name;
        this.cache = cache;
    }

    public void destroy() throws CacheException {
    }

    public long getElementCountInMemory() {
        return -1L;
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public String getName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public int getTimeout() {
        return -1;
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public Map toMap() {
        try {
            HashMap result = new HashMap();
            for (Object key : this.cache.keys(this.regionName)) {
                CacheObject e = this.cache.get(this.regionName, (String)key);
                if (e == null) continue;
                result.put(key, e);
            }
            return result;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void evict(Object key) throws CacheException {
        this.cache.evict(this.regionName, new String[]{(String)key});
    }

    public void evictAll() throws CacheException {
        this.cache.clear(this.regionName);
    }

    public Object get(Object key) throws CacheException {
        return this.cache.get(this.regionName, (String)key);
    }

    public void put(Object key, Object value) throws CacheException {
        this.cache.set(this.regionName, (String)key, value);
    }

    static final class Timestamps
    extends J2CacheRegion
    implements TimestampsRegion {
        public Timestamps(String name, CacheChannel cache) {
            super(name, cache);
        }
    }

    static final class Collection
    extends Transactional
    implements CollectionRegion {
        public Collection(String name, CacheChannel cache) {
            super(name, cache);
        }

        public CollectionRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
            return null;
        }
    }

    static final class Entity
    extends Transactional
    implements EntityRegion {
        public Entity(String name, CacheChannel cache) {
            super(name, cache);
        }

        public EntityRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
            return null;
        }
    }

    static final class QueryResults
    extends J2CacheRegion
    implements QueryResultsRegion {
        public QueryResults(String name, CacheChannel cache) {
            super(name, cache);
        }
    }

    private static class Transactional
    extends J2CacheRegion
    implements TransactionalDataRegion {
        public Transactional(String name, CacheChannel cache) {
            super(name, cache);
        }

        public CacheDataDescription getCacheDataDescription() {
            return null;
        }

        public boolean isTransactionAware() {
            return false;
        }
    }
}

