package validator.spring;

/*
 * #%L
 * helpers.validation.osgi.services
 * %%
 * Copyright (C) 2013 Osgiliath corp
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;

import org.springframework.validation.beanvalidation.SpringValidatorAdapter;

/**
 * Subclass of
 * {@link org.springframework.validation.beanvalidation.SpringValidatorAdapter
 * SpringValidatorAdapter} that will expose a
 * {@link javax.validation.ValidatorFactory ValidatorFactory} through the
 * {@link org.springframework.validation.Validator} interface.
 * 
 */
@Deprecated
public class OsgiValidatorFactoryBean extends SpringValidatorAdapter implements ValidatorFactory {

  /**
   * Constructor that takes an instance of {@link ValidatorFactory} to expose
   * through the {@link org.springframework.validation.Validator} interface.
   * @param validatorFactory ValidatorFactory instance
   */
  public OsgiValidatorFactoryBean(ValidatorFactory validatorFactory) {
    super(validatorFactory.getValidator());
    this.validatorFactory = validatorFactory;
  }

  private ValidatorFactory validatorFactory;

  public Validator getValidator() {
    return this.validatorFactory.getValidator();
  }

  public ValidatorContext usingContext() {
    return this.validatorFactory.usingContext();
  }

  public MessageInterpolator getMessageInterpolator() {
    return this.validatorFactory.getMessageInterpolator();
  }

  public TraversableResolver getTraversableResolver() {
    return this.validatorFactory.getTraversableResolver();
  }

  public ConstraintValidatorFactory getConstraintValidatorFactory() {
    return this.validatorFactory.getConstraintValidatorFactory();
  }

@Override
public ExecutableValidator forExecutables() {
	// TODO Auto-generated method stub
	return null;
}

@Override
public ParameterNameProvider getParameterNameProvider() {
	// TODO Auto-generated method stub
	return null;
}

@Override
public void close() {
	// TODO Auto-generated method stub
	
}
}
