/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.validator.osgi.internal;

import java.util.Collection;
import javax.validation.spi.ValidationProvider;
import net.osgiliath.validator.osgi.internal.HibernateValidationOSGIServicesProviderResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OsgiServiceValidationProviderTracker
implements ServiceTrackerCustomizer {
    private final BundleContext context;

    public OsgiServiceValidationProviderTracker(BundleContext context) {
        this.context = context;
    }

    public Object addingService(ServiceReference reference) {
        Object serviceObject = this.context.getService(reference);
        if (serviceObject instanceof ValidationProvider && !HibernateValidationOSGIServicesProviderResolver.getInstance().getValidationProviders().contains(serviceObject)) {
            HibernateValidationOSGIServicesProviderResolver.getInstance().getValidationProviders().add((ValidationProvider)serviceObject);
        }
        return reference;
    }

    public void removedService(ServiceReference reference, Object service) {
        Object serviceObject = this.context.getService(reference);
        if (serviceObject instanceof ValidationProvider && HibernateValidationOSGIServicesProviderResolver.getInstance().getValidationProviders().contains(serviceObject)) {
            HibernateValidationOSGIServicesProviderResolver.getInstance().getValidationProviders().remove((ValidationProvider)serviceObject);
        }
    }

    public static void handleInitialReferences(BundleContext context) throws InvalidSyntaxException {
        Collection refs = context.getServiceReferences(ValidationProvider.class, null);
        for (ServiceReference reference : refs) {
            HibernateValidationOSGIServicesProviderResolver.getInstance().getValidationProviders().add(context.getService(reference));
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.removedService(reference, service);
        this.addingService(reference);
    }
}

