/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import net.ossindex.common.VulnerabilityDescriptor;

public class PackageDescriptor {
    private long id;
    private String pm;
    private String name;
    private String version;
    private String group;
    @SerializedName(value="vulnerability-total")
    private int vulnerabilityTotal;
    @SerializedName(value="vulnerability-matches")
    private int vulnerabilityMatches;
    private List<VulnerabilityDescriptor> vulnerabilities;

    public PackageDescriptor(String pm, String groupId, String artifactId, String version) {
        this.pm = pm;
        this.name = artifactId;
        this.version = version;
        this.group = groupId;
    }

    public long getId() {
        return this.id;
    }

    public List<VulnerabilityDescriptor> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PKG: [" + this.id + "] " + this.getPmPackageId());
        return sb.toString();
    }

    public String getGroup() {
        if (this.group != null) {
            return this.group;
        }
        return "";
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "";
    }

    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        return "";
    }

    public int getVulnerabilityTotal() {
        return this.vulnerabilityTotal;
    }

    public int getVulnerabilityMatches() {
        return this.vulnerabilityMatches;
    }

    public String getPmPackageId() {
        StringBuilder sb = new StringBuilder();
        if (this.pm != null) {
            sb.append(this.pm);
        }
        sb.append(":");
        if (this.group != null) {
            sb.append(this.group);
        }
        sb.append(":");
        if (this.name != null) {
            sb.append(this.name);
        }
        sb.append(":");
        if (this.version != null) {
            sb.append(this.version);
        }
        sb.append(":");
        return sb.toString();
    }

    public String getPackageId() {
        StringBuilder sb = new StringBuilder();
        if (this.group != null) {
            sb.append(this.group);
        }
        sb.append(":");
        if (this.name != null) {
            sb.append(this.name);
        }
        sb.append(":");
        if (this.version != null) {
            sb.append(this.version);
        }
        sb.append(":");
        return sb.toString();
    }

    public int hashCode() {
        return this.getPmPackageId().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof PackageDescriptor) {
            PackageDescriptor pkg = (PackageDescriptor)o;
            if (this.pm != null && !this.pm.equals(pkg.pm)) {
                return false;
            }
            if (this.group != null && !this.group.equals(pkg.group)) {
                return false;
            }
            if (this.name != null && !this.name.equals(pkg.name)) {
                return false;
            }
            return this.version == null || this.version.equals(pkg.version);
        }
        return false;
    }
}

